<?php
// views/pages/services.php
// Services page view

$page_title = 'Hizmetlerimiz';
ob_start();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hizmetlerimiz - <?php echo htmlspecialchars($settings['site_title'] ?? 'Salon Pasa'); ?></title>
    <meta name="description" content="Salon Pasa düğün organizasyon hizmetlerimiz - Fotoğraf, catering, müzik ve daha fazlası">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #c9a96e;
            --secondary-color: #8b4513;
            --accent-color: #f8f6f0;
            --text-dark: #2c2c2c;
            --text-light: #666;
            --gradient-primary: linear-gradient(135deg, #c9a96e 0%, #d4af37 100%);
            --gradient-secondary: linear-gradient(135deg, #8b4513 0%, #a0522d 100%);
            --shadow-light: 0 10px 30px rgba(201, 169, 110, 0.15);
            --shadow-medium: 0 15px 40px rgba(201, 169, 110, 0.25);
            --shadow-heavy: 0 20px 50px rgba(201, 169, 110, 0.35);
        }

        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }

        .dancing-script {
            font-family: 'Dancing Script', cursive;
        }

        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            font-family: 'Dancing Script', cursive;
            font-size: 2.2rem;
            font-weight: 700;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .navbar-nav .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-color) !important;
        }

        .page-header {
            height: 60vh;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo htmlspecialchars($settings['hero_image'] ?? 'images/img_bg_2.jpg'); ?>');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
        }

        .services-section {
            padding: 80px 0;
            background: var(--accent-color);
        }

        .section-title {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title h2 {
            font-family: 'Dancing Script', cursive;
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .service-card {
            background: white;
            border-radius: 25px;
            padding: 0;
            text-align: center;
            box-shadow: var(--shadow-light);
            transition: all 0.4s ease;
            height: 100%;
            border: 2px solid transparent;
            margin-bottom: 30px;
            position: relative;
            overflow: hidden;
        }

        .service-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-primary);
            transform: scaleX(0);
            transition: transform 0.3s ease;
            z-index: 2;
        }

        .service-card:hover::before {
            transform: scaleX(1);
        }

        .service-card:hover {
            transform: translateY(-15px);
            box-shadow: var(--shadow-heavy);
            border-color: var(--primary-color);
        }
        .service-image-container {
            position: relative;
            width: 100%;
            height: 200px;
            overflow: hidden;
            border-radius: 25px 25px 0 0;
        }

        .service-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .service-card:hover .service-image {
            transform: scale(1.1);
        }

        .service-icon-overlay {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 50px;
            height: 50px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            color: var(--primary-color);
            box-shadow: var(--shadow-light);
            transition: all 0.3s ease;
        }

        .service-card:hover .service-icon-overlay {
            transform: scale(1.1) rotate(5deg);
            background: var(--primary-color);
            color: white;
        }

        .service-content {
            padding: 30px 25px;
        }

        .service-card h4 {
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--text-dark);
            font-size: 1.4rem;
        }

        .service-card p {
            color: var(--text-light);
            margin-bottom: 25px;
            line-height: 1.7;
            font-size: 0.95rem;
        }

        .service-price {
            font-size: 2rem;
            font-weight: 800;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 20px;
        }

        .service-features {
            list-style: none;
            padding: 0;
            margin-bottom: 25px;
        }

        .service-features li {
            color: var(--text-light);
            margin-bottom: 8px;
            position: relative;
            padding-left: 20px;
            font-size: 0.9rem;
        }

        .service-features li::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: var(--primary-color);
            font-weight: bold;
        }

        .service-btn {
            display: inline-block;
            background: var(--gradient-primary);
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-light);
            font-size: 0.95rem;
        }

        .service-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-medium);
            color: white;
        }

        .service-content h5 {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 10px;
        }

        .service-content ul {
            padding-left: 20px;
        }

        .service-content li {
            margin-bottom: 5px;
            color: var(--text-light);
        }

        .footer {
            background: var(--text-dark);
            color: white;
            padding: 60px 0 30px;
        }

        .footer h5 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }

        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: var(--primary-color);
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/">Salon Pasa</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/about">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="/services">Hizmetler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/gallery">Galeri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/contact">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1 class="dancing-script display-4">Hizmetlerimiz</h1>
            <p class="lead">Düğününüzün her detayını profesyonelce planlıyoruz</p>
        </div>
    </section>

    <!-- Services Section -->
    <section class="services-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">Hizmetlerimiz</h2>
                <p>Düğününüzün her detayını profesyonelce planlıyoruz</p>
            </div>
            <div class="row">
                <?php if (!empty($services)): ?>
                    <?php foreach ($services as $service): ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card">
                            <div class="service-image-container">
                                    <?php if (!empty($service['image_path'])): ?>
                                        <img src="<?php echo htmlspecialchars($service['image_path']); ?>" 
                                             alt="<?php echo htmlspecialchars($service['title']); ?>"
                                             class="service-image">
                                    <?php else: ?>
                                        <img src="/assets/images/services/default-service.jpg" 
                                             alt="<?php echo htmlspecialchars($service['title']); ?>"
                                             class="service-image">
                                    <?php endif; ?>
                                    <div class="service-icon-overlay">
                                        <i class="fas fa-concierge-bell"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                <h4><?php echo htmlspecialchars($service['title']); ?></h4>
                                <p><?php echo htmlspecialchars($service['description']); ?></p>
                                
                                <?php if ($service['price']): ?>
                                    <div class="service-price">₺<?php echo number_format($service['price'], 0); ?></div>
                                <?php endif; ?>
                                
                                <?php if ($service['features']): ?>
                                    <ul class="service-features">
                                        <?php foreach (explode(',', $service['features']) as $feature): ?>
                                            <li><?php echo trim($feature); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                                
                                <?php if ($service['content']): ?>
                                    <div class="service-content">
                                        <?php echo $service['content']; ?>
                                    </div>
                                <?php endif; ?>
                                </div>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Örnek Hizmetler -->
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/photography.jpg" alt="Fotoğraf & Video" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-camera"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Fotoğraf & Video</h4>
                                <p>Profesyonel fotoğraf ve video çekimi ile düğününüzün en güzel anlarını ölümsüzleştiriyoruz. Deneyimli ekibimizle unutulmaz anılar yaratıyoruz.</p>
                                <div class="service-price">₺15.000</div>
                                <ul class="service-features">
                                    <li>Profesyonel fotoğrafçı (8 saat)</li>
                                    <li>Drone çekimi</li>
                                    <li>Düzenleme ve albüm</li>
                                    <li>HD video montajı</li>
                                    <li>Online galeri</li>
                                    <li>USB ile teslim</li>
                                </ul>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/catering.jpg" alt="Catering Hizmetleri" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-utensils"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Catering Hizmetleri</h4>
                                <p>Lezzetli yemekler ve profesyonel servis ile misafirlerinizi memnun ediyoruz. Özel menülerimizle damak zevkinize hitap ediyoruz.</p>
                                <div class="service-price">₺85/kişi</div>
                                <ul class="service-features">
                                    <li>5 çeşit ana yemek</li>
                                    <li>Profesyonel servis</li>
                                    <li>İçecek servisi</li>
                                    <li>Dekoratif sunum</li>
                                    <li>Çocuk menüsü</li>
                                    <li>Özel diyet menüleri</li>
                                </ul>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/music.jpg" alt="Müzik & Eğlence" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-music"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Müzik & Eğlence</h4>
                                <p>Canlı müzik ve DJ hizmetleri ile düğününüzü unutulmaz kılıyoruz. Dans pistinde eğlence garantisi!</p>
                                <div class="service-price">₺8.500</div>
                                <ul class="service-features">
                                    <li>Profesyonel DJ</li>
                                    <li>Canlı müzik</li>
                                    <li>Ses sistemi</li>
                                    <li>Dans pisti aydınlatması</li>
                                    <li>Mikrofon sistemi</li>
                                    <li>Özel şarkı talepleri</li>
                                </ul>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/decoration.jpg" alt="Dekorasyon" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-palette"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Dekorasyon</h4>
                                <p>Yaratıcı dekorasyon fikirleri ile düğününüzü hayalinizdeki gibi süslüyoruz. Her detayda mükemmellik!</p>
                                <div class="service-price">₺12.000</div>
                                <ul class="service-features">
                                    <li>Çiçek düzenlemeleri</li>
                                    <li>Masa dekorasyonu</li>
                                    <li>Işıklandırma</li>
                                    <li>Fotoğraf köşesi</li>
                                    <li>Giriş dekorasyonu</li>
                                    <li>Özel tema tasarımı</li>
                                </ul>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/transportation.jpg" alt="Ulaşım Hizmetleri" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-car"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Ulaşım Hizmetleri</h4>
                                <p>Lüks araçlarımızla düğününüzde konforlu ulaşım sağlıyoruz. Şık ve güvenli seyahat garantisi.</p>
                                <div class="service-price">₺2.500</div>
                                <ul class="service-features">
                                    <li>Lüks araç filosu</li>
                                    <li>Profesyonel şoför</li>
                                    <li>Dekoratif süsleme</li>
                                    <li>Güvenlik garantisi</li>
                                    <li>Esnek saatler</li>
                                    <li>Misafir ulaşımı</li>
                                </ul>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/full-organization.jpg" alt="Tam Organizasyon" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-concierge-bell"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Tam Organizasyon</h4>
                                <p>Tüm hizmetleri tek pakette sunuyoruz. Düğününüzün her detayını bizimle birlikte planlayın!</p>
                                <div class="service-price">₺45.000</div>
                                <ul class="service-features">
                                    <li>Tüm hizmetler dahil</li>
                                    <li>Kişisel organizatör</li>
                                    <li>Günlük koordinasyon</li>
                                    <li>Özel indirimler</li>
                                    <li>7/24 destek</li>
                                    <li>Garanti hizmeti</li>
                                </ul>
                                <a href="/contact" class="service-btn">Teklif Al</a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="dancing-script">Salon Pasa</h5>
                    <p><?php echo htmlspecialchars($settings['site_description'] ?? 'Salon Pasa ile hayalinizdeki düğünü gerçekleştirin. Profesyonel düğün organizasyon hizmetleri.'); ?></p>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5>Sayfalar</h5>
                    <ul class="list-unstyled">
                        <li><a href="/">Ana Sayfa</a></li>
                        <li><a href="/about">Hakkımızda</a></li>
                        <li><a href="/services">Hizmetler</a></li>
                        <li><a href="/gallery">Galeri</a></li>
                        <li><a href="/contact">İletişim</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5>İletişim</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                    <p><i class="fas fa-phone me-2"></i><?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?></p>
                    <p><i class="fas fa-envelope me-2"></i><?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?></p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-md-6">
                    <p>&copy; <?php echo date('Y'); ?> Salon Pasa. Tüm hakları saklıdır.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$content = ob_get_clean();
echo $content;
?>
