<?php
// views/pages/gallery.php
// Gallery page view

$page_title = 'Galeri';
ob_start();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galeri - <?php echo htmlspecialchars($settings['site_title'] ?? 'Salon Pasa'); ?></title>
    <meta name="description" content="Salon Pasa düğün galerisi - Gerçekleştirdiğimiz düğünlerden en güzel kareler">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #c9a96e;
            --secondary-color: #8b4513;
            --accent-color: #f8f6f0;
            --text-dark: #2c2c2c;
            --text-light: #666;
            --gradient-primary: linear-gradient(135deg, #c9a96e 0%, #d4af37 100%);
            --gradient-secondary: linear-gradient(135deg, #8b4513 0%, #a0522d 100%);
            --shadow-light: 0 10px 30px rgba(201, 169, 110, 0.15);
            --shadow-medium: 0 15px 40px rgba(201, 169, 110, 0.25);
            --shadow-heavy: 0 20px 50px rgba(201, 169, 110, 0.35);
        }

        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }

        .dancing-script {
            font-family: 'Dancing Script', cursive;
        }

        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            font-family: 'Dancing Script', cursive;
            font-size: 2.2rem;
            font-weight: 700;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .navbar-nav .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-color) !important;
        }

        .page-header {
            height: 60vh;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo htmlspecialchars($settings['hero_image'] ?? 'images/img_bg_2.jpg'); ?>');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
        }

        .gallery-section {
            padding: 80px 0;
            background: white;
        }

        .section-title {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title h2 {
            font-family: 'Dancing Script', cursive;
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
            margin-top: 40px;
        }

        .gallery-item {
            position: relative;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: var(--shadow-light);
            transition: all 0.4s ease;
            background: white;
        }

        .gallery-item:hover {
            transform: translateY(-10px) scale(1.02);
            box-shadow: var(--shadow-heavy);
        }

        .gallery-item img {
            width: 100%;
            height: 300px;
            object-fit: cover;
            transition: all 0.4s ease;
        }

        .gallery-item:hover img {
            transform: scale(1.1);
        }

        .gallery-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: var(--gradient-primary);
            opacity: 0;
            transition: all 0.4s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }

        .gallery-item:hover .gallery-overlay {
            opacity: 0.9;
        }

        .gallery-overlay i {
            color: white;
            font-size: 2.5rem;
            margin-bottom: 10px;
        }

        .gallery-overlay h5 {
            color: white;
            font-weight: 600;
            margin: 0;
            text-align: center;
        }

        .gallery-info {
            padding: 20px;
            background: white;
        }

        .gallery-info h6 {
            color: var(--text-dark);
            font-weight: 600;
            margin-bottom: 5px;
        }

        .gallery-info p {
            color: var(--text-light);
            font-size: 0.9rem;
            margin: 0;
        }

        .category-filter {
            text-align: center;
            margin-bottom: 50px;
        }

        .category-btn {
            background: transparent;
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            padding: 12px 25px;
            margin: 8px;
            border-radius: 30px;
            transition: all 0.3s ease;
            font-weight: 600;
            font-size: 0.95rem;
        }

        .category-btn:hover,
        .category-btn.active {
            background: var(--gradient-primary);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow-light);
        }

        .masonry-grid {
            column-count: 3;
            column-gap: 25px;
            margin-top: 40px;
        }

        .masonry-item {
            break-inside: avoid;
            margin-bottom: 25px;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: var(--shadow-light);
            transition: all 0.4s ease;
        }

        .masonry-item:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-medium);
        }

        .masonry-item img {
            width: 100%;
            height: auto;
            display: block;
        }

        @media (max-width: 768px) {
            .masonry-grid {
                column-count: 2;
            }
            
            .gallery-grid {
                grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            }
        }

        @media (max-width: 480px) {
            .masonry-grid {
                column-count: 1;
            }
        }

        .footer {
            background: var(--text-dark);
            color: white;
            padding: 60px 0 30px;
        }

        .footer h5 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }

        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: var(--primary-color);
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/">Salon Pasa</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/about">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/services">Hizmetler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="/gallery">Galeri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/contact">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1 class="dancing-script display-4">Galerimiz</h1>
            <p class="lead">Gerçekleştirdiğimiz düğünlerden kareler</p>
        </div>
    </section>

    <!-- Gallery Section -->
    <section class="gallery-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">Galerimiz</h2>
                <p>Gerçekleştirdiğimiz düğünlerden kareler</p>
            </div>

            <!-- Category Filter -->
            <?php if (!empty($categories)): ?>
                <div class="category-filter">
                    <button class="category-btn active" data-category="all">Tümü</button>
                    <?php foreach ($categories as $category): ?>
                        <button class="category-btn" data-category="<?php echo $category['id']; ?>">
                            <?php echo htmlspecialchars($category['name']); ?>
                        </button>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <div class="gallery-grid">
                <?php if (!empty($images)): ?>
                    <?php foreach ($images as $image): ?>
                        <div class="gallery-item" data-category="<?php echo $image['category_id'] ?: '0'; ?>">
                            <img src="/<?php echo htmlspecialchars($image['thumbnail_path'] ?: $image['image_path']); ?>" 
                                 alt="<?php echo htmlspecialchars($image['alt_text'] ?: $image['title']); ?>">
                            <div class="gallery-overlay">
                                <i class="fas fa-search-plus"></i>
                                <h5><?php echo htmlspecialchars($image['title'] ?: 'Düğün Fotoğrafı'); ?></h5>
                            </div>
                            <div class="gallery-info">
                                <h6><?php echo htmlspecialchars($image['title'] ?: 'Düğün Fotoğrafı'); ?></h6>
                                <p><?php echo htmlspecialchars($image['description'] ?: 'Salon Pasa ile gerçekleştirilen düğün'); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Örnek Galeri Fotoğrafları -->
                    <div class="gallery-item" data-category="1">
                        <img src="images/gallery-1.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Gelin & Damat</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Gelin & Damat</h6>
                            <p>Salon Pasa ile gerçekleştirilen düğün</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="2">
                        <img src="images/gallery-2.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Düğün Töreni</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Düğün Töreni</h6>
                            <p>Unutulmaz düğün töreni anları</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="3">
                        <img src="images/gallery-3.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Dans Pistinde</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Dans Pistinde</h6>
                            <p>Eğlenceli dans anları</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="1">
                        <img src="images/gallery-4.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Çift Fotoğrafı</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Çift Fotoğrafı</h6>
                            <p>Romantik çift fotoğrafları</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="2">
                        <img src="images/gallery-5.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Düğün Yemeği</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Düğün Yemeği</h6>
                            <p>Lezzetli düğün yemeği</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="3">
                        <img src="images/gallery-6.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Eğlence</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Eğlence</h6>
                            <p>Düğün eğlence anları</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="1">
                        <img src="images/gallery-7.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Gelin Fotoğrafı</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Gelin Fotoğrafı</h6>
                            <p>Güzel gelin fotoğrafları</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="2">
                        <img src="images/gallery-8.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Düğün Dekorasyonu</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Düğün Dekorasyonu</h6>
                            <p>Şık düğün dekorasyonu</p>
                        </div>
                    </div>
                    
                    <div class="gallery-item" data-category="3">
                        <img src="images/gallery-9.jpg" alt="Düğün Fotoğrafı">
                        <div class="gallery-overlay">
                            <i class="fas fa-search-plus"></i>
                            <h5>Misafirler</h5>
                        </div>
                        <div class="gallery-info">
                            <h6>Misafirler</h6>
                            <p>Mutlu misafirler</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="dancing-script">Salon Pasa</h5>
                    <p><?php echo htmlspecialchars($settings['site_description'] ?? 'Salon Pasa ile hayalinizdeki düğünü gerçekleştirin. Profesyonel düğün organizasyon hizmetleri.'); ?></p>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5>Sayfalar</h5>
                    <ul class="list-unstyled">
                        <li><a href="/">Ana Sayfa</a></li>
                        <li><a href="/about">Hakkımızda</a></li>
                        <li><a href="/services">Hizmetler</a></li>
                        <li><a href="/gallery">Galeri</a></li>
                        <li><a href="/contact">İletişim</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5>İletişim</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                    <p><i class="fas fa-phone me-2"></i><?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?></p>
                    <p><i class="fas fa-envelope me-2"></i><?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?></p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-md-6">
                    <p>&copy; <?php echo date('Y'); ?> Salon Pasa. Tüm hakları saklıdır.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Category filter functionality
        document.querySelectorAll('.category-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // Remove active class from all buttons
                document.querySelectorAll('.category-btn').forEach(b => b.classList.remove('active'));
                // Add active class to clicked button
                this.classList.add('active');
                
                const category = this.getAttribute('data-category');
                const items = document.querySelectorAll('.gallery-item');
                
                items.forEach(item => {
                    if (category === 'all' || item.getAttribute('data-category') === category) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });
        });
    </script>
</body>
</html>

<?php
$content = ob_get_clean();
echo $content;
?>
