<?php
// views/pages/contact.php
// Contact page view

$page_title = 'İletişim';
ob_start();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İletişim - <?php echo htmlspecialchars($settings['site_title'] ?? 'Salon Pasa'); ?></title>
    <meta name="description" content="Salon Pasa ile iletişime geçin - Düğün organizasyon hizmetleri için bizimle iletişime geçin">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #c9a96e;
            --secondary-color: #8b4513;
            --accent-color: #f8f6f0;
            --text-dark: #2c2c2c;
            --text-light: #666;
            --gradient-primary: linear-gradient(135deg, #c9a96e 0%, #d4af37 100%);
            --gradient-secondary: linear-gradient(135deg, #8b4513 0%, #a0522d 100%);
            --shadow-light: 0 10px 30px rgba(201, 169, 110, 0.15);
            --shadow-medium: 0 15px 40px rgba(201, 169, 110, 0.25);
            --shadow-heavy: 0 20px 50px rgba(201, 169, 110, 0.35);
        }

        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }

        .dancing-script {
            font-family: 'Dancing Script', cursive;
        }

        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            font-family: 'Dancing Script', cursive;
            font-size: 2.2rem;
            font-weight: 700;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .navbar-nav .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-color) !important;
        }

        .page-header {
            height: 60vh;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo htmlspecialchars($settings['hero_image'] ?? 'images/img_bg_2.jpg'); ?>');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
        }

        .contact-section {
            padding: 80px 0;
            background: white;
        }

        .section-title {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title h2 {
            font-family: 'Dancing Script', cursive;
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .contact-info {
            background: var(--accent-color);
            border-radius: 15px;
            padding: 40px;
            height: 100%;
        }

        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
        }

        .contact-item i {
            width: 50px;
            height: 50px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 20px;
        }

        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(212, 175, 55, 0.25);
        }

        .btn-primary {
            background: var(--primary-color);
            border: none;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .alert {
            border-radius: 10px;
            border: none;
        }

        .footer {
            background: var(--text-dark);
            color: white;
            padding: 60px 0 30px;
        }

        .footer h5 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }

        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: var(--primary-color);
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/">Salon Pasa</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/about">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/services">Hizmetler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/gallery">Galeri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="/contact">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1 class="dancing-script display-4">İletişim</h1>
            <p class="lead">Bizimle iletişime geçin, hayalinizdeki düğünü planlayalım</p>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">İletişim</h2>
                <p>Bizimle iletişime geçin, hayalinizdeki düğünü planlayalım</p>
            </div>

            <!-- Flash Messages -->
            <?php if ($flash_success = getFlashMessage('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i><?php echo $flash_success; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($flash_error = getFlashMessage('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i><?php echo $flash_error; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-8">
                    <form method="POST" action="/contact">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">Ad Soyad *</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">Email *</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">Telefon</label>
                                <input type="tel" class="form-control" id="phone" name="phone">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="subject" class="form-label">Konu</label>
                                <input type="text" class="form-control" id="subject" name="subject">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="message" class="form-label">Mesajınız *</label>
                            <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane me-2"></i>Mesaj Gönder
                        </button>
                    </form>
                </div>
                <div class="col-lg-4">
                    <div class="contact-info">
                        <h4 class="mb-4">İletişim Bilgileri</h4>
                        
                        <div class="contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div>
                                <h6>Adres</h6>
                                <p><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fas fa-phone"></i>
                            <div>
                                <h6>Telefon</h6>
                                <p><a href="tel:<?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?>" class="text-decoration-none">
                                    <?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?>
                                </a></p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <div>
                                <h6>Email</h6>
                                <p><a href="mailto:<?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?>" class="text-decoration-none">
                                    <?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?>
                                </a></p>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fas fa-clock"></i>
                            <div>
                                <h6>Çalışma Saatleri</h6>
                                <p>Pazartesi - Cuma: 09:00 - 18:00<br>
                                Cumartesi: 10:00 - 16:00<br>
                                Pazar: Kapalı</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="dancing-script">Salon Pasa</h5>
                    <p><?php echo htmlspecialchars($settings['site_description'] ?? 'Salon Pasa ile hayalinizdeki düğünü gerçekleştirin. Profesyonel düğün organizasyon hizmetleri.'); ?></p>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5>Sayfalar</h5>
                    <ul class="list-unstyled">
                        <li><a href="/">Ana Sayfa</a></li>
                        <li><a href="/about">Hakkımızda</a></li>
                        <li><a href="/services">Hizmetler</a></li>
                        <li><a href="/gallery">Galeri</a></li>
                        <li><a href="/contact">İletişim</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5>İletişim</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                    <p><i class="fas fa-phone me-2"></i><?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?></p>
                    <p><i class="fas fa-envelope me-2"></i><?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?></p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-md-6">
                    <p>&copy; <?php echo date('Y'); ?> Salon Pasa. Tüm hakları saklıdır.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
</body>
</html>

<?php
$content = ob_get_clean();
echo $content;
?>
