<?php
// views/pages/about.php
// About page view

$page_title = 'Hakkımızda';
ob_start();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hakkımızda - <?php echo htmlspecialchars($settings['site_title'] ?? 'Salon Pasa'); ?></title>
    <meta name="description" content="Salon Pasa düğün organizasyon şirketi hakkında bilgiler - Profesyonel ekibimiz ve deneyimimiz">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #c9a96e;
            --secondary-color: #8b4513;
            --accent-color: #f8f6f0;
            --text-dark: #2c2c2c;
            --text-light: #666;
            --gradient-primary: linear-gradient(135deg, #c9a96e 0%, #d4af37 100%);
            --gradient-secondary: linear-gradient(135deg, #8b4513 0%, #a0522d 100%);
            --shadow-light: 0 10px 30px rgba(201, 169, 110, 0.15);
            --shadow-medium: 0 15px 40px rgba(201, 169, 110, 0.25);
            --shadow-heavy: 0 20px 50px rgba(201, 169, 110, 0.35);
        }

        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }

        .dancing-script {
            font-family: 'Dancing Script', cursive;
        }

        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            font-family: 'Dancing Script', cursive;
            font-size: 2.2rem;
            font-weight: 700;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .navbar-nav .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-color) !important;
        }

        .page-header {
            height: 60vh;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo htmlspecialchars($settings['hero_image'] ?? 'images/img_bg_2.jpg'); ?>');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
        }

        .page-content {
            padding: 80px 0;
        }

        .section-title {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title h2 {
            font-family: 'Dancing Script', cursive;
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .content-card {
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: var(--shadow-light);
            margin-bottom: 40px;
            position: relative;
            overflow: hidden;
        }

        .content-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-primary);
        }

        .about-section {
            margin-bottom: 60px;
        }

        .about-section h3 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 20px;
            font-size: 1.5rem;
        }

        .about-section p {
            color: var(--text-light);
            line-height: 1.8;
            margin-bottom: 20px;
            font-size: 1.1rem;
        }

        .stats-section {
            background: var(--accent-color);
            padding: 60px 0;
            margin: 60px 0;
        }

        .stat-item {
            text-align: center;
            padding: 30px;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 800;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 10px;
        }

        .stat-label {
            color: var(--text-dark);
            font-weight: 600;
            font-size: 1.1rem;
        }

        .team-section {
            padding: 60px 0;
        }

        .team-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            text-align: center;
            box-shadow: var(--shadow-light);
            transition: all 0.3s ease;
            margin-bottom: 30px;
        }

        .team-card:hover {
            transform: translateY(-10px);
            box-shadow: var(--shadow-medium);
        }

        .team-photo {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            background: var(--gradient-primary);
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 3rem;
        }

        .team-card h5 {
            color: var(--text-dark);
            font-weight: 700;
            margin-bottom: 10px;
        }

        .team-card p {
            color: var(--text-light);
            margin-bottom: 15px;
        }

        .team-social a {
            display: inline-block;
            width: 40px;
            height: 40px;
            background: var(--gradient-primary);
            color: white;
            border-radius: 50%;
            text-align: center;
            line-height: 40px;
            margin: 0 5px;
            transition: all 0.3s ease;
        }

        .team-social a:hover {
            transform: translateY(-3px);
            box-shadow: var(--shadow-light);
        }

        .values-list {
            list-style: none;
            padding: 0;
        }

        .values-list li {
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
            color: var(--text-light);
            font-size: 1.1rem;
        }

        .values-list li:last-child {
            border-bottom: none;
        }

        .values-list li::before {
            content: '✓';
            color: var(--primary-color);
            font-weight: bold;
            margin-right: 15px;
            font-size: 1.3rem;
        }

        .footer {
            background: var(--text-dark);
            color: white;
            padding: 60px 0 30px;
        }

        .footer h5 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }

        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: var(--primary-color);
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/">Salon Pasa</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="/about">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/services">Hizmetler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/gallery">Galeri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/contact">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1 class="dancing-script display-4">Hakkımızda</h1>
            <p class="lead">Düğün organizasyon şirketimiz hakkında bilgiler</p>
        </div>
    </section>

    <!-- Page Content -->
    <section class="page-content">
        <div class="container">
            <?php if ($page && $page['content']): ?>
                <div class="content-card">
                    <?php echo $page['content']; ?>
                </div>
            <?php else: ?>
                <!-- Salon Pasa Hakkında İçerik -->
                <div class="content-card">
                    <div class="about-section">
                        <h3>Salon Pasa Hikayesi</h3>
                        <p>Salon Pasa olarak, 2015 yılından bu yana düğün organizasyon sektöründe faaliyet gösteriyoruz. Hayalinizdeki düğünü gerçekleştirmek için buradayız. Profesyonel ekibimizle, düğününüzün her detayını özenle planlıyor ve unutulmaz anlar yaratıyoruz.</p>
                        
                        <p>Deneyimli ekibimiz, yaratıcı yaklaşımımız ve müşteri memnuniyeti odaklı hizmet anlayışımızla, düğün organizasyon sektöründe öncü konumdayız. Her düğün bizim için özeldir ve her çiftin hayallerini gerçeğe dönüştürmek için çalışırız.</p>
                    </div>
                    
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="about-section">
                                <h3>Misyonumuz</h3>
                                <p>Hayalinizdeki düğünü gerçekleştirmek için buradayız. Profesyonel ekibimizle, düğününüzün her detayını özenle planlıyor ve unutulmaz anlar yaratıyoruz. Müşterilerimizin mutluluğu bizim en büyük ödülümüzdür.</p>
                                
                                <h3>Vizyonumuz</h3>
                                <p>Düğün organizasyon sektöründe öncü olmak ve müşterilerimizin hayallerini gerçeğe dönüştürmek. Türkiye'nin en güvenilir ve yaratıcı düğün organizasyon şirketi olmak.</p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="about-section">
                                <h3>Değerlerimiz</h3>
                                <ul class="values-list">
                                    <li>Müşteri memnuniyeti odaklı yaklaşım</li>
                                    <li>Profesyonellik ve kalite</li>
                                    <li>Yaratıcılık ve özgünlük</li>
                                    <li>Güvenilirlik ve şeffaflık</li>
                                    <li>Detaylara önem verme</li>
                                    <li>Zamanında teslimat</li>
                                    <li>Uygun fiyat politikası</li>
                                    <li>Sürekli gelişim ve yenilik</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- İstatistikler -->
                <div class="stats-section">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-3 col-md-6">
                                <div class="stat-item">
                                    <div class="stat-number">500+</div>
                                    <div class="stat-label">Mutlu Çift</div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="stat-item">
                                    <div class="stat-number">8</div>
                                    <div class="stat-label">Yıllık Deneyim</div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="stat-item">
                                    <div class="stat-number">50+</div>
                                    <div class="stat-label">Profesyonel Ekip</div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="stat-item">
                                    <div class="stat-number">100%</div>
                                    <div class="stat-label">Müşteri Memnuniyeti</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Ekip -->
                <div class="team-section">
                    <div class="container">
                        <div class="section-title">
                            <h2 class="dancing-script">Ekibimiz</h2>
                            <p>Deneyimli ve profesyonel ekibimizle tanışın</p>
                        </div>
                        <div class="row">
                            <div class="col-lg-4 col-md-6">
                                <div class="team-card">
                                    <div class="team-photo">
                                        <i class="fas fa-user-tie"></i>
                                    </div>
                                    <h5>Ahmet Yılmaz</h5>
                                    <p>Genel Müdür & Kurucu</p>
                                    <p>8 yıllık düğün organizasyon deneyimi</p>
                                    <div class="team-social">
                                        <a href="#"><i class="fab fa-linkedin"></i></a>
                                        <a href="#"><i class="fab fa-instagram"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6">
                                <div class="team-card">
                                    <div class="team-photo">
                                        <i class="fas fa-user-graduate"></i>
                                    </div>
                                    <h5>Ayşe Demir</h5>
                                    <p>Organizasyon Uzmanı</p>
                                    <p>5 yıllık deneyim, müşteri ilişkileri uzmanı</p>
                                    <div class="team-social">
                                        <a href="#"><i class="fab fa-linkedin"></i></a>
                                        <a href="#"><i class="fab fa-instagram"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6">
                                <div class="team-card">
                                    <div class="team-photo">
                                        <i class="fas fa-camera"></i>
                                    </div>
                                    <h5>Mehmet Kaya</h5>
                                    <p>Fotoğraf & Video Uzmanı</p>
                                    <p>Profesyonel fotoğrafçı, 6 yıllık deneyim</p>
                                    <div class="team-social">
                                        <a href="#"><i class="fab fa-linkedin"></i></a>
                                        <a href="#"><i class="fab fa-instagram"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="dancing-script">Salon Pasa</h5>
                    <p><?php echo htmlspecialchars($settings['site_description'] ?? 'Salon Pasa ile hayalinizdeki düğünü gerçekleştirin. Profesyonel düğün organizasyon hizmetleri.'); ?></p>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5>Sayfalar</h5>
                    <ul class="list-unstyled">
                        <li><a href="/">Ana Sayfa</a></li>
                        <li><a href="/about">Hakkımızda</a></li>
                        <li><a href="/services">Hizmetler</a></li>
                        <li><a href="/gallery">Galeri</a></li>
                        <li><a href="/contact">İletişim</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5>İletişim</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                    <p><i class="fas fa-phone me-2"></i><?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?></p>
                    <p><i class="fas fa-envelope me-2"></i><?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?></p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-md-6">
                    <p>&copy; <?php echo date('Y'); ?> Salon Pasa. Tüm hakları saklıdır.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$content = ob_get_clean();
echo $content;
?>
