<?php
// views/home/index.php
// Home page view for wedding organization

$page_title = 'Ana Sayfa';
ob_start();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($settings['site_title'] ?? 'Salon Pasa'); ?> - Profesyonel Düğün Organizasyon</title>
    <meta name="description" content="<?php echo htmlspecialchars($settings['site_description'] ?? 'Salon Pasa ile hayalinizdeki düğünü gerçekleştirin. Profesyonel düğün organizasyon hizmetleri.'); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #c9a96e;
            --secondary-color: #8b4513;
            --accent-color: #f8f6f0;
            --text-dark: #2c2c2c;
            --text-light: #666;
            --gradient-primary: linear-gradient(135deg, #c9a96e 0%, #d4af37 100%);
            --gradient-secondary: linear-gradient(135deg, #8b4513 0%, #a0522d 100%);
            --shadow-light: 0 10px 30px rgba(201, 169, 110, 0.15);
            --shadow-medium: 0 15px 40px rgba(201, 169, 110, 0.25);
            --shadow-heavy: 0 20px 50px rgba(201, 169, 110, 0.35);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
        }

        .dancing-script {
            font-family: 'Dancing Script', cursive;
        }

        /* Header Styles */
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }

        .navbar-brand {
            font-family: 'Dancing Script', cursive;
            font-size: 2.2rem;
            font-weight: 700;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .navbar-nav .nav-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            margin: 0 10px;
            transition: color 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-color) !important;
        }

        /* Hero Section */
        .hero-section {
            height: 100vh;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo htmlspecialchars($settings['hero_image'] ?? 'images/img_bg_2.jpg'); ?>');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            color: white;
        }

        .hero-content h1 {
            font-family: 'Dancing Script', cursive;
            font-size: 4rem;
            font-weight: 700;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }

        .hero-content h2 {
            font-size: 1.5rem;
            font-weight: 300;
            margin-bottom: 2rem;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
        }

        .btn-primary {
            background: var(--gradient-primary);
            border: none;
            padding: 15px 35px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-light);
            position: relative;
            overflow: hidden;
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-primary:hover {
            background: var(--gradient-secondary);
            transform: translateY(-3px);
            box-shadow: var(--shadow-medium);
        }

        /* Services Section */
        .services-section {
            padding: 80px 0;
            background: var(--accent-color);
        }

        .section-title {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title h2 {
            font-family: 'Dancing Script', cursive;
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .section-title p {
            font-size: 1.1rem;
            color: var(--text-light);
            max-width: 600px;
            margin: 0 auto;
        }

        .service-card {
            background: white;
            border-radius: 25px;
            text-align: center;
            box-shadow: var(--shadow-light);
            transition: all 0.4s ease;
            height: 100%;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
        }

        .service-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-primary);
            transform: scaleX(0);
            transition: transform 0.3s ease;
            z-index: 2;
        }

        .service-card:hover::before {
            transform: scaleX(1);
        }

        .service-card:hover {
            transform: translateY(-15px);
            box-shadow: var(--shadow-heavy);
            border-color: var(--primary-color);
        }

        .service-image-container {
            position: relative;
            width: 100%;
            height: 200px;
            overflow: hidden;
            border-radius: 25px 25px 0 0;
        }

        .service-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .service-card:hover .service-image {
            transform: scale(1.1);
        }

        .service-icon-overlay {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 50px;
            height: 50px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            color: var(--primary-color);
            box-shadow: var(--shadow-light);
            transition: all 0.3s ease;
        }

        .service-card:hover .service-icon-overlay {
            transform: scale(1.1) rotate(5deg);
            background: var(--primary-color);
            color: white;
        }

        .service-content {
            padding: 30px 25px;
        }

        .service-card h4 {
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--text-dark);
            font-size: 1.4rem;
        }

        .service-card p {
            color: var(--text-light);
            margin-bottom: 25px;
            line-height: 1.7;
            font-size: 0.95rem;
        }

        .service-price {
            font-size: 2rem;
            font-weight: 800;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 20px;
        }

        .service-features {
            list-style: none;
            padding: 0;
            margin-bottom: 25px;
        }

        .service-features li {
            color: var(--text-light);
            margin-bottom: 8px;
            position: relative;
            padding-left: 20px;
            font-size: 0.9rem;
        }

        .service-features li::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: var(--primary-color);
            font-weight: bold;
        }

        .service-btn {
            display: inline-block;
            background: var(--gradient-primary);
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-light);
            font-size: 0.95rem;
        }

        .service-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-medium);
            color: white;
        }

        /* Gallery Section */

        /* Gallery Section */
        .gallery-section {
            padding: 80px 0;
            background: white;
        }

        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 40px;
        }

        .gallery-item {
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }

        .gallery-item:hover {
            transform: scale(1.05);
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
        }

        .gallery-item img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            transition: all 0.3s ease;
        }

        .gallery-item:hover img {
            transform: scale(1.1);
        }

        .gallery-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(212, 175, 55, 0.8), rgba(139, 69, 19, 0.8));
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: all 0.3s ease;
        }

        .gallery-item:hover .gallery-overlay {
            opacity: 1;
        }

        .gallery-overlay i {
            color: white;
            font-size: 2rem;
        }

        /* Testimonials Section */
        .testimonials-section {
            padding: 80px 0;
            background: var(--accent-color);
        }

        .testimonial-card {
            background: white;
            border-radius: 15px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin: 20px 0;
        }

        .testimonial-card .stars {
            color: var(--primary-color);
            font-size: 1.2rem;
            margin-bottom: 20px;
        }

        .testimonial-card p {
            font-style: italic;
            font-size: 1.1rem;
            margin-bottom: 20px;
            color: var(--text-light);
        }

        .testimonial-card h5 {
            font-weight: 600;
            color: var(--text-dark);
        }

        /* Contact Section */
        .contact-section {
            padding: 80px 0;
            background: white;
        }

        .contact-info {
            background: var(--accent-color);
            border-radius: 15px;
            padding: 40px;
            height: 100%;
        }

        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
        }

        .contact-item i {
            width: 50px;
            height: 50px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 20px;
        }

        /* Footer */
        .footer {
            background: var(--text-dark);
            color: white;
            padding: 60px 0 30px;
        }

        .footer h5 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }

        .footer a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: var(--primary-color);
        }

        .social-links a {
            display: inline-block;
            width: 40px;
            height: 40px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            text-align: center;
            line-height: 40px;
            margin-right: 10px;
            transition: all 0.3s ease;
        }

        .social-links a:hover {
            background: var(--secondary-color);
            transform: translateY(-3px);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero-content h1 {
                font-size: 2.5rem;
            }
            
            .section-title h2 {
                font-size: 2rem;
            }
            
            .service-card {
                margin-bottom: 30px;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/">Salon Pasa</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/about">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/services">Hizmetler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/gallery">Galeri</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/contact">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="hero-content">
                <h1 class="dancing-script"><?php echo htmlspecialchars($settings['hero_title'] ?? 'Hayalinizdeki Düğünü Salon Pasa ile Gerçekleştirin'); ?></h1>
                <h2><?php echo htmlspecialchars($settings['hero_subtitle'] ?? 'Profesyonel düğün organizasyon hizmetleri ile unutulmaz anlar yaratıyoruz'); ?></h2>
                <a href="/contact" class="btn btn-primary btn-lg">Hemen İletişime Geçin</a>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="services-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">Hizmetlerimiz</h2>
                <p>Düğününüzün her detayını profesyonelce planlıyoruz</p>
            </div>
            <div class="row">
                <?php if (!empty($services)): ?>
                    <?php foreach ($services as $service): ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card">
                                <div class="service-image-container">
                                    <?php if (!empty($service['image_path'])): ?>
                                        <img src="<?php echo htmlspecialchars($service['image_path']); ?>" 
                                             alt="<?php echo htmlspecialchars($service['title']); ?>"
                                             class="service-image">
                                    <?php else: ?>
                                        <img src="/assets/images/services/default-service.jpg" 
                                             alt="<?php echo htmlspecialchars($service['title']); ?>"
                                             class="service-image">
                                    <?php endif; ?>
                                    <div class="service-icon-overlay">
                                        <i class="fas fa-concierge-bell"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4><?php echo htmlspecialchars($service['title']); ?></h4>
                                    <p><?php echo htmlspecialchars($service['description']); ?></p>
                                    
                                    <?php if ($service['price']): ?>
                                        <div class="service-price">₺<?php echo number_format($service['price'], 0); ?></div>
                                    <?php endif; ?>
                                    
                                    <?php if ($service['features']): ?>
                                        <ul class="service-features">
                                            <?php foreach (explode(',', $service['features']) as $feature): ?>
                                                <li><?php echo trim($feature); ?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                    
                                    <a href="/contact" class="service-btn">Detaylı Bilgi</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Örnek Hizmetler -->
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/photography.jpg" alt="Fotoğraf & Video" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-camera"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Fotoğraf & Video</h4>
                                <p>Profesyonel fotoğraf ve video çekimi ile düğününüzün en güzel anlarını ölümsüzleştiriyoruz.</p>
                                <div class="service-price">₺15.000</div>
                                <ul class="service-features">
                                    <li>Profesyonel fotoğrafçı</li>
                                    <li>Drone çekimi</li>
                                    <li>Düzenleme ve albüm</li>
                                    <li>HD video montajı</li>
                                </ul>
                                <a href="/contact" class="service-btn">Detaylı Bilgi</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/catering.jpg" alt="Catering Hizmetleri" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-utensils"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Catering Hizmetleri</h4>
                                <p>Lezzetli yemekler ve profesyonel servis ile misafirlerinizi memnun ediyoruz.</p>
                                <div class="service-price">₺85/kişi</div>
                                <ul class="service-features">
                                    <li>5 çeşit ana yemek</li>
                                    <li>Profesyonel servis</li>
                                    <li>İçecek servisi</li>
                                    <li>Dekoratif sunum</li>
                                </ul>
                                <a href="/contact" class="service-btn">Detaylı Bilgi</a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="service-card">
                            <div class="service-image-container">
                                <img src="/assets/images/services/music.jpg" alt="Müzik & Eğlence" class="service-image">
                                <div class="service-icon-overlay">
                                    <i class="fas fa-music"></i>
                                </div>
                            </div>
                            <div class="service-content">
                                <h4>Müzik & Eğlence</h4>
                                <p>Canlı müzik ve DJ hizmetleri ile düğününüzü unutulmaz kılıyoruz.</p>
                                <div class="service-price">₺8.500</div>
                                <ul class="service-features">
                                    <li>Profesyonel DJ</li>
                                    <li>Canlı müzik</li>
                                    <li>Ses sistemi</li>
                                    <li>Dans pisti aydınlatması</li>
                                </ul>
                                <a href="/contact" class="service-btn">Detaylı Bilgi</a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Gallery Section -->
    <section class="gallery-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">Galerimiz</h2>
                <p>Gerçekleştirdiğimiz düğünlerden kareler</p>
            </div>
            <div class="gallery-grid">
                <?php if (!empty($featuredImages)): ?>
                    <?php foreach ($featuredImages as $image): ?>
                        <div class="gallery-item">
                            <img src="/<?php echo htmlspecialchars($image['thumbnail_path'] ?: $image['image_path']); ?>" 
                                 alt="<?php echo htmlspecialchars($image['alt_text'] ?: $image['title']); ?>">
                            <div class="gallery-overlay">
                                <i class="fas fa-search-plus"></i>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 text-center">
                        <p class="text-muted">Galeri fotoğrafları yakında eklenecek...</p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="text-center mt-4">
                <a href="/gallery" class="btn btn-primary">Tüm Galeriyi Görüntüle</a>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="testimonials-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">Müşteri Yorumları</h2>
                <p>Mutlu çiftlerimizin deneyimleri</p>
            </div>
            <div class="row">
                <?php if (!empty($testimonials)): ?>
                    <?php foreach ($testimonials as $testimonial): ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="testimonial-card">
                                <div class="stars">
                                    <?php for ($i = 0; $i < $testimonial['rating']; $i++): ?>
                                        <i class="fas fa-star"></i>
                                    <?php endfor; ?>
                                </div>
                                <p>"<?php echo htmlspecialchars($testimonial['testimonial']); ?>"</p>
                                <h5><?php echo htmlspecialchars($testimonial['client_name']); ?></h5>
                                <?php if ($testimonial['client_title']): ?>
                                    <small class="text-muted"><?php echo htmlspecialchars($testimonial['client_title']); ?></small>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 text-center">
                        <p class="text-muted">Müşteri yorumları yakında eklenecek...</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section">
        <div class="container">
            <div class="section-title">
                <h2 class="dancing-script">İletişim</h2>
                <p>Bizimle iletişime geçin, hayalinizdeki düğünü planlayalım</p>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <form method="POST" action="/contact">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <input type="text" class="form-control" name="name" placeholder="Ad Soyad" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <input type="email" class="form-control" name="email" placeholder="Email" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <input type="tel" class="form-control" name="phone" placeholder="Telefon">
                            </div>
                            <div class="col-md-6 mb-3">
                                <input type="text" class="form-control" name="subject" placeholder="Konu">
                            </div>
                        </div>
                        <div class="mb-3">
                            <textarea class="form-control" name="message" rows="5" placeholder="Mesajınız" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Mesaj Gönder</button>
                    </form>
                </div>
                <div class="col-lg-4">
                    <div class="contact-info">
                        <div class="contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div>
                                <h6>Adres</h6>
                                <p><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <i class="fas fa-phone"></i>
                            <div>
                                <h6>Telefon</h6>
                                <p><?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?></p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <div>
                                <h6>Email</h6>
                                <p><?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="dancing-script">Salon Pasa</h5>
                    <p><?php echo htmlspecialchars($settings['site_description'] ?? 'Salon Pasa ile hayalinizdeki düğünü gerçekleştirin. Profesyonel düğün organizasyon hizmetleri.'); ?></p>
                    <div class="social-links">
                        <?php if ($settings['facebook_url']): ?>
                            <a href="<?php echo htmlspecialchars($settings['facebook_url']); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if ($settings['instagram_url']): ?>
                            <a href="<?php echo htmlspecialchars($settings['instagram_url']); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if ($settings['twitter_url']): ?>
                            <a href="<?php echo htmlspecialchars($settings['twitter_url']); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
                        <?php endif; ?>
                        <?php if ($settings['linkedin_url']): ?>
                            <a href="<?php echo htmlspecialchars($settings['linkedin_url']); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5>Sayfalar</h5>
                    <ul class="list-unstyled">
                        <li><a href="/">Ana Sayfa</a></li>
                        <li><a href="/about">Hakkımızda</a></li>
                        <li><a href="/services">Hizmetler</a></li>
                        <li><a href="/gallery">Galeri</a></li>
                        <li><a href="/contact">İletişim</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5>Hizmetler</h5>
                    <ul class="list-unstyled">
                        <li><a href="#">Düğün Organizasyonu</a></li>
                        <li><a href="#">Fotoğraf & Video</a></li>
                        <li><a href="#">Mekan Düzenleme</a></li>
                        <li><a href="#">Catering</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5>İletişim</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i><?php echo htmlspecialchars($settings['contact_address'] ?? 'İstanbul, Türkiye'); ?></p>
                    <p><i class="fas fa-phone me-2"></i><?php echo htmlspecialchars($settings['contact_phone'] ?? '+90 555 123 45 67'); ?></p>
                    <p><i class="fas fa-envelope me-2"></i><?php echo htmlspecialchars($settings['contact_email'] ?? 'info@weddingmaster.com'); ?></p>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-md-6">
                    <p>&copy; <?php echo date('Y'); ?> Salon Pasa. Tüm hakları saklıdır.</p>
                </div>
                <div class="col-md-6 text-end">
                    <a href="/admin" class="text-muted">Admin Panel</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.background = 'rgba(255, 255, 255, 0.98)';
            } else {
                navbar.style.background = 'rgba(255, 255, 255, 0.95)';
            }
        });

        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
    </script>
</body>
</html>

<?php
$content = ob_get_clean();
echo $content;
?>
