<?php
// views/admin/testimonials/index.php
// Testimonials management page

$page_title = 'Referanslar Yönetimi';
ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Referanslar</h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#testimonialModal">
        <i class="fas fa-plus me-2"></i>Yeni Referans Ekle
    </button>
</div>

<div class="card">
    <div class="card-body">
        <?php if (empty($testimonials)): ?>
            <div class="text-center py-5">
                <i class="fas fa-quote-left fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Henüz referans eklenmemiş</h5>
                <p class="text-muted">İlk referansınızı eklemek için yukarıdaki butona tıklayın.</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Müşteri</th>
                            <th>Referans</th>
                            <th>Puan</th>
                            <th>Durum</th>
                            <th>Öne Çıkan</th>
                            <th>Tarih</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($testimonials as $testimonial): ?>
                            <tr>
                                <td>
                                    <div>
                                        <strong><?php echo htmlspecialchars($testimonial['client_name']); ?></strong>
                                        <?php if ($testimonial['client_title']): ?>
                                            <br><small class="text-muted"><?php echo htmlspecialchars($testimonial['client_title']); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <div style="max-width: 300px;">
                                        <?php echo htmlspecialchars(truncateText($testimonial['testimonial'], 100)); ?>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star <?php echo $i <= $testimonial['rating'] ? 'text-warning' : 'text-muted'; ?>"></i>
                                        <?php endfor; ?>
                                        <span class="ms-2"><?php echo $testimonial['rating']; ?>/5</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge <?php echo $testimonial['is_active'] ? 'bg-success' : 'bg-secondary'; ?>">
                                        <?php echo $testimonial['is_active'] ? 'Aktif' : 'Pasif'; ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if ($testimonial['is_featured']): ?>
                                        <i class="fas fa-star text-warning"></i>
                                    <?php else: ?>
                                        <i class="fas fa-star text-muted"></i>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <?php echo formatDate($testimonial['created_at'], 'd.m.Y'); ?>
                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="editTestimonial(<?php echo $testimonial['id']; ?>)">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-outline-danger" onclick="deleteTestimonial(<?php echo $testimonial['id']; ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Testimonial Modal -->
<div class="modal fade" id="testimonialModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Referans Ekle/Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="/admin/testimonials">
                <div class="modal-body">
                    <input type="hidden" name="action" id="testimonialAction" value="create">
                    <input type="hidden" name="id" id="testimonialId">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="client_name" class="form-label">Müşteri Adı *</label>
                                <input type="text" class="form-control" id="client_name" name="client_name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="client_title" class="form-label">Müşteri Ünvanı</label>
                                <input type="text" class="form-control" id="client_title" name="client_title">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="testimonial" class="form-label">Referans Metni *</label>
                        <textarea class="form-control" id="testimonial" name="testimonial" rows="4" required></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="rating" class="form-label">Puan</label>
                                <select class="form-select" id="rating" name="rating">
                                    <option value="5">5 Yıldız</option>
                                    <option value="4">4 Yıldız</option>
                                    <option value="3">3 Yıldız</option>
                                    <option value="2">2 Yıldız</option>
                                    <option value="1">1 Yıldız</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sıralama</label>
                                <input type="number" class="form-control" id="sort_order" name="sort_order" value="0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <div class="form-check mt-4">
                                    <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured">
                                    <label class="form-check-label" for="is_featured">
                                        Öne Çıkar
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editTestimonial(id) {
    // Bu fonksiyon testimonial verilerini modal'a yükleyecek
    // Şimdilik modal'ı açıyoruz
    document.getElementById('testimonialAction').value = 'update';
    document.getElementById('testimonialId').value = id;
    
    // Modal'ı aç
    const modal = new bootstrap.Modal(document.getElementById('testimonialModal'));
    modal.show();
}

function deleteTestimonial(id) {
    if (confirm('Bu referansı silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '/admin/testimonials';
        
        const actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'action';
        actionInput.value = 'delete';
        
        const idInput = document.createElement('input');
        idInput.type = 'hidden';
        idInput.name = 'id';
        idInput.value = id;
        
        form.appendChild(actionInput);
        form.appendChild(idInput);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
