<?php
// views/admin/settings/index.php
// Site settings management page

$page_title = 'Site Ayarları';
ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-cog me-2"></i>Site Ayarları</h2>
    <button class="btn btn-success" onclick="saveSettings()">
        <i class="fas fa-save me-2"></i>Ayarları Kaydet
    </button>
</div>

<form id="settingsForm" method="POST">
    <div class="row">
        <div class="col-lg-8">
            <!-- General Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>Genel Ayarlar
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_site_title" class="form-label">Site Başlığı</label>
                                <input type="text" class="form-control" id="setting_site_title" name="setting_site_title" 
                                       value="<?php echo htmlspecialchars($settings['site_title'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_contact_email" class="form-label">İletişim Email</label>
                                <input type="email" class="form-control" id="setting_contact_email" name="setting_contact_email" 
                                       value="<?php echo htmlspecialchars($settings['contact_email'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="setting_site_description" class="form-label">Site Açıklaması</label>
                        <textarea class="form-control" id="setting_site_description" name="setting_site_description" rows="3"><?php echo htmlspecialchars($settings['site_description'] ?? ''); ?></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_contact_phone" class="form-label">İletişim Telefon</label>
                                <input type="text" class="form-control" id="setting_contact_phone" name="setting_contact_phone" 
                                       value="<?php echo htmlspecialchars($settings['contact_phone'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_contact_address" class="form-label">İletişim Adresi</label>
                                <input type="text" class="form-control" id="setting_contact_address" name="setting_contact_address" 
                                       value="<?php echo htmlspecialchars($settings['contact_address'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Homepage Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-home me-2"></i>Ana Sayfa Ayarları
                    </h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="setting_hero_title" class="form-label">Ana Başlık</label>
                        <input type="text" class="form-control" id="setting_hero_title" name="setting_hero_title" 
                               value="<?php echo htmlspecialchars($settings['hero_title'] ?? ''); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="setting_hero_subtitle" class="form-label">Ana Alt Başlık</label>
                        <input type="text" class="form-control" id="setting_hero_subtitle" name="setting_hero_subtitle" 
                               value="<?php echo htmlspecialchars($settings['hero_subtitle'] ?? ''); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="setting_hero_image" class="form-label">Ana Sayfa Arka Plan Resmi</label>
                        <input type="text" class="form-control" id="setting_hero_image" name="setting_hero_image" 
                               value="<?php echo htmlspecialchars($settings['hero_image'] ?? ''); ?>">
                        <div class="form-text">Resim yolu (örn: images/hero-bg.jpg)</div>
                    </div>
                </div>
            </div>

            <!-- Social Media Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-share-alt me-2"></i>Sosyal Medya Ayarları
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_facebook_url" class="form-label">Facebook URL</label>
                                <input type="url" class="form-control" id="setting_facebook_url" name="setting_facebook_url" 
                                       value="<?php echo htmlspecialchars($settings['facebook_url'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_instagram_url" class="form-label">Instagram URL</label>
                                <input type="url" class="form-control" id="setting_instagram_url" name="setting_instagram_url" 
                                       value="<?php echo htmlspecialchars($settings['instagram_url'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_twitter_url" class="form-label">Twitter URL</label>
                                <input type="url" class="form-control" id="setting_twitter_url" name="setting_twitter_url" 
                                       value="<?php echo htmlspecialchars($settings['twitter_url'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="setting_linkedin_url" class="form-label">LinkedIn URL</label>
                                <input type="url" class="form-control" id="setting_linkedin_url" name="setting_linkedin_url" 
                                       value="<?php echo htmlspecialchars($settings['linkedin_url'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Preview Card -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-eye me-2"></i>Önizleme
                    </h5>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <h4 id="preview_title"><?php echo htmlspecialchars($settings['site_title'] ?? 'Site Başlığı'); ?></h4>
                        <p class="text-muted" id="preview_description"><?php echo htmlspecialchars($settings['site_description'] ?? 'Site açıklaması'); ?></p>
                        <hr>
                        <p><strong>İletişim:</strong></p>
                        <p id="preview_email"><?php echo htmlspecialchars($settings['contact_email'] ?? 'Email adresi'); ?></p>
                        <p id="preview_phone"><?php echo htmlspecialchars($settings['contact_phone'] ?? 'Telefon numarası'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-bolt me-2"></i>Hızlı İşlemler
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="/" class="btn btn-outline-primary" target="_blank">
                            <i class="fas fa-external-link-alt me-2"></i>Siteyi Görüntüle
                        </a>
                        <button type="button" class="btn btn-outline-secondary" onclick="resetSettings()">
                            <i class="fas fa-undo me-2"></i>Ayarları Sıfırla
                        </button>
                        <button type="button" class="btn btn-outline-info" onclick="exportSettings()">
                            <i class="fas fa-download me-2"></i>Ayarları Dışa Aktar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
function saveSettings() {
    document.getElementById('settingsForm').submit();
}

function resetSettings() {
    if (confirm('Tüm ayarları varsayılan değerlere sıfırlamak istediğinizden emin misiniz?')) {
        location.reload();
    }
}

function exportSettings() {
    const settings = {
        site_title: document.getElementById('setting_site_title').value,
        site_description: document.getElementById('setting_site_description').value,
        contact_email: document.getElementById('setting_contact_email').value,
        contact_phone: document.getElementById('setting_contact_phone').value,
        contact_address: document.getElementById('setting_contact_address').value,
        hero_title: document.getElementById('setting_hero_title').value,
        hero_subtitle: document.getElementById('setting_hero_subtitle').value,
        hero_image: document.getElementById('setting_hero_image').value,
        facebook_url: document.getElementById('setting_facebook_url').value,
        instagram_url: document.getElementById('setting_instagram_url').value,
        twitter_url: document.getElementById('setting_twitter_url').value,
        linkedin_url: document.getElementById('setting_linkedin_url').value
    };
    
    const dataStr = JSON.stringify(settings, null, 2);
    const dataBlob = new Blob([dataStr], {type: 'application/json'});
    const url = URL.createObjectURL(dataBlob);
    const link = document.createElement('a');
    link.href = url;
    link.download = 'site-settings.json';
    link.click();
    URL.revokeObjectURL(url);
}

// Live preview updates
document.getElementById('setting_site_title').addEventListener('input', function() {
    document.getElementById('preview_title').textContent = this.value || 'Site Başlığı';
});

document.getElementById('setting_site_description').addEventListener('input', function() {
    document.getElementById('preview_description').textContent = this.value || 'Site açıklaması';
});

document.getElementById('setting_contact_email').addEventListener('input', function() {
    document.getElementById('preview_email').textContent = this.value || 'Email adresi';
});

document.getElementById('setting_contact_phone').addEventListener('input', function() {
    document.getElementById('preview_phone').textContent = this.value || 'Telefon numarası';
});
</script>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
