<?php
// views/admin/services/index.php
// Services management page

$page_title = 'Hizmetler Yönetimi';
ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-concierge-bell me-2"></i>Hizmetler</h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#serviceModal">
        <i class="fas fa-plus me-2"></i>Yeni Hizmet Ekle
    </button>
</div>

<div class="card">
    <div class="card-body">
        <?php if (!empty($services)): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>Resim</th>
                            <th>Başlık</th>
                            <th>Açıklama</th>
                            <th>Fiyat</th>
                            <th>Durum</th>
                            <th>Öne Çıkan</th>
                            <th>Sıra</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($services as $service): ?>
                            <tr>
                                <td>
                                    <?php if ($service['image_path']): ?>
                                        <img src="../<?php echo htmlspecialchars($service['image_path']); ?>" alt="<?php echo htmlspecialchars($service['title']); ?>" style="width: 50px; height: 50px;">
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?php echo htmlspecialchars($service['title']); ?></strong>
                                    
                                </td>
                                <td><?php echo truncateText($service['description'], 100); ?></td>
                                <td>
                                    <?php if ($service['price']): ?>
                                        ₺<?php echo number_format($service['price'], 2); ?>
                                    <?php else: ?>
                                        <span class="text-muted">Belirtilmemiş</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($service['is_active']): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Pasif</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($service['is_featured']): ?>
                                        <span class="badge bg-warning">Öne Çıkan</span>
                                    <?php else: ?>
                                        <span class="badge bg-light text-dark">Normal</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $service['sort_order']; ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="editService(<?php echo htmlspecialchars(json_encode($service)); ?>)">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-outline-danger" onclick="deleteService(<?php echo $service['id']; ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-concierge-bell fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Henüz hizmet eklenmemiş</h5>
                <p class="text-muted">İlk hizmetinizi eklemek için yukarıdaki butona tıklayın.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Service Modal -->
<div class="modal fade" id="serviceModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalTitle">Yeni Hizmet Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="serviceForm" method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="action" id="serviceAction" value="create">
                    <input type="hidden" name="id" id="serviceId">
                    
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="title" class="form-label">Hizmet Başlığı *</label>
                                <input type="text" class="form-control" id="title" name="title" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="image_path" class="form-label">Resim</label>
                                <input type="file" class="form-control" id="image_path" name="image_path" accept="image/*" required>
                                <small class="form-text text-muted">JPG, PNG, GIF, WebP formatları desteklenir. Maksimum 5MB.</small>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Kısa Açıklama *</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Detaylı İçerik</label>
                        <textarea class="form-control" id="content" name="content" rows="5"></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="features" class="form-label">Özellikler (virgülle ayırın)</label>
                        <textarea class="form-control" id="features" name="features" rows="4" placeholder="Özellik 1, Özellik 2, Özellik 3"></textarea>
                        <small class="form-text text-muted">Her özelliği virgülle ayırın. Örnek: Profesyonel fotoğrafçı, Drone çekimi, Düzenleme ve albüm</small>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="price" class="form-label">Fiyat (₺)</label>
                                <input type="number" class="form-control" id="price" name="price" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sıra</label>
                                <input type="number" class="form-control" id="sort_order" name="sort_order" value="0">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured">
                                <label class="form-check-label" for="is_featured">
                                    Öne Çıkan Hizmet
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                                <label class="form-check-label" for="is_active">
                                    Aktif
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editService(service) {
    document.getElementById('serviceModalTitle').textContent = 'Hizmet Düzenle';
    document.getElementById('serviceAction').value = 'update';
    document.getElementById('serviceId').value = service.id;
    document.getElementById('title').value = service.title;
    document.getElementById('description').value = service.description;
    document.getElementById('content').value = service.content || '';
    document.getElementById('features').value = service.features || '';
    document.getElementById('price').value = service.price || '';
    document.getElementById('sort_order').value = service.sort_order;
    document.getElementById('is_featured').checked = service.is_featured == 1;
    document.getElementById('is_active').checked = service.is_active == 1;
    
    // Update işleminde resim zorunlu değil
    const imageInput = document.getElementById('image_path');
    imageInput.removeAttribute('required');
    imageInput.value = '';
    
    // Mevcut resim bilgisini göster
    const imageLabel = imageInput.previousElementSibling;
    if (service.image_path) {
        imageLabel.innerHTML = `Resim (Mevcut: ${service.image_path.split('/').pop()})`;
    } else {
        imageLabel.innerHTML = 'Resim';
    }
    
    const modal = new bootstrap.Modal(document.getElementById('serviceModal'));
    modal.show();
}

function deleteService(id) {
    if (confirm('Bu hizmeti silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

// Reset form when modal is hidden
document.getElementById('serviceModal').addEventListener('hidden.bs.modal', function () {
    document.getElementById('serviceForm').reset();
    document.getElementById('serviceAction').value = 'create';
    document.getElementById('serviceModalTitle').textContent = 'Yeni Hizmet Ekle';
    
    // Resim input'unu tekrar zorunlu yap
    const imageInput = document.getElementById('image_path');
    imageInput.setAttribute('required', 'required');
    imageInput.value = '';
    
    // Label'ı sıfırla
    const imageLabel = imageInput.previousElementSibling;
    imageLabel.innerHTML = 'Resim';
});
</script>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
