<?php
// views/admin/pages/index.php
// Pages management page

$page_title = 'Sayfalar Yönetimi';
ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Sayfalar</h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#pageModal">
        <i class="fas fa-plus me-2"></i>Yeni Sayfa Ekle
    </button>
</div>

<div class="card">
    <div class="card-body">
        <?php if (empty($pages)): ?>
            <div class="text-center py-5">
                <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Henüz sayfa eklenmemiş</h5>
                <p class="text-muted">İlk sayfanızı eklemek için yukarıdaki butona tıklayın.</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Başlık</th>
                            <th>Slug</th>
                            <th>Durum</th>
                            <th>Sıralama</th>
                            <th>Tarih</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pages as $page): ?>
                            <tr>
                                <td>
                                    <div>
                                        <strong><?php echo htmlspecialchars($page['title']); ?></strong>
                                        <?php if ($page['meta_description']): ?>
                                            <br><small class="text-muted"><?php echo htmlspecialchars(truncateText($page['meta_description'], 60)); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <code><?php echo htmlspecialchars($page['slug']); ?></code>
                                </td>
                                <td>
                                    <span class="badge <?php echo $page['is_active'] ? 'bg-success' : 'bg-secondary'; ?>">
                                        <?php echo $page['is_active'] ? 'Aktif' : 'Pasif'; ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?php echo $page['sort_order']; ?></span>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <?php echo formatDate($page['created_at'], 'd.m.Y'); ?>
                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="/<?php echo $page['slug']; ?>" class="btn btn-outline-info" target="_blank" title="Görüntüle">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <button class="btn btn-outline-primary" onclick="editPage(<?php echo $page['id']; ?>)">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-outline-danger" onclick="deletePage(<?php echo $page['id']; ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Page Modal -->
<div class="modal fade" id="pageModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Sayfa Ekle/Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="/admin/pages">
                <div class="modal-body">
                    <input type="hidden" name="action" id="pageAction" value="create">
                    <input type="hidden" name="id" id="pageId">
                    
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="title" class="form-label">Sayfa Başlığı *</label>
                                <input type="text" class="form-control" id="title" name="title" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="slug" class="form-label">Slug *</label>
                                <input type="text" class="form-control" id="slug" name="slug" required>
                                <small class="form-text text-muted">URL'de görünecek kısım (örn: hakkimizda)</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="meta_description" class="form-label">Meta Açıklama</label>
                                <textarea class="form-control" id="meta_description" name="meta_description" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="meta_keywords" class="form-label">Meta Anahtar Kelimeler</label>
                                <textarea class="form-control" id="meta_keywords" name="meta_keywords" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="content" class="form-label">İçerik *</label>
                        <textarea class="form-control" id="content" name="content" rows="10" required></textarea>
                        <small class="form-text text-muted">HTML etiketleri kullanabilirsiniz</small>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sıralama</label>
                                <input type="number" class="form-control" id="sort_order" name="sort_order" value="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <div class="form-check mt-4">
                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                                    <label class="form-check-label" for="is_active">
                                        Aktif
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Auto-generate slug from title
document.getElementById('title').addEventListener('input', function() {
    const title = this.value;
    const slug = title.toLowerCase()
        .replace(/[^a-z0-9\s-]/g, '')
        .replace(/\s+/g, '-')
        .replace(/-+/g, '-')
        .trim('-');
    document.getElementById('slug').value = slug;
});

function editPage(id) {
    // Bu fonksiyon page verilerini modal'a yükleyecek
    // Şimdilik modal'ı açıyoruz
    document.getElementById('pageAction').value = 'update';
    document.getElementById('pageId').value = id;
    
    // Modal'ı aç
    const modal = new bootstrap.Modal(document.getElementById('pageModal'));
    modal.show();
}

function deletePage(id) {
    if (confirm('Bu sayfayı silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '/admin/pages';
        
        const actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'action';
        actionInput.value = 'delete';
        
        const idInput = document.createElement('input');
        idInput.type = 'hidden';
        idInput.name = 'id';
        idInput.value = id;
        
        form.appendChild(actionInput);
        form.appendChild(idInput);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
