<?php
// views/admin/messages/index.php
// Contact messages management page

$page_title = 'İletişim Mesajları';
ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-envelope me-2"></i>İletişim Mesajları</h2>
    <div class="btn-group">
        <button class="btn btn-outline-primary" onclick="markAllAsRead()">
            <i class="fas fa-check-double me-2"></i>Tümünü Okundu İşaretle
        </button>
        <button class="btn btn-outline-danger" onclick="deleteAllRead()">
            <i class="fas fa-trash me-2"></i>Okunanları Sil
        </button>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <?php if (!empty($messages)): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th width="5%">
                                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()">
                            </th>
                            <th width="20%">Ad Soyad</th>
                            <th width="20%">Email</th>
                            <th width="15%">Telefon</th>
                            <th width="20%">Konu</th>
                            <th width="10%">Tarih</th>
                            <th width="10%">Durum</th>
                            <th width="10%">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($messages as $message): ?>
                            <tr class="<?php echo $message['is_read'] ? '' : 'table-warning'; ?>">
                                <td>
                                    <input type="checkbox" class="message-checkbox" value="<?php echo $message['id']; ?>">
                                </td>
                                <td>
                                    <strong><?php echo htmlspecialchars($message['name']); ?></strong>
                                </td>
                                <td>
                                    <a href="mailto:<?php echo htmlspecialchars($message['email']); ?>" class="text-decoration-none">
                                        <?php echo htmlspecialchars($message['email']); ?>
                                    </a>
                                </td>
                                <td>
                                    <?php if ($message['phone']): ?>
                                        <a href="tel:<?php echo htmlspecialchars($message['phone']); ?>" class="text-decoration-none">
                                            <?php echo htmlspecialchars($message['phone']); ?>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($message['subject']): ?>
                                        <?php echo htmlspecialchars($message['subject']); ?>
                                    <?php else: ?>
                                        <span class="text-muted">Konu yok</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small><?php echo formatDate($message['created_at'], 'd.m.Y H:i'); ?></small>
                                </td>
                                <td>
                                    <?php if ($message['is_read']): ?>
                                        <span class="badge bg-success">Okundu</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning">Okunmadı</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="viewMessage(<?php echo htmlspecialchars(json_encode($message)); ?>)">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <?php if ($message['is_read']): ?>
                                            <button class="btn btn-outline-warning" onclick="markAsUnread(<?php echo $message['id']; ?>)">
                                                <i class="fas fa-envelope"></i>
                                            </button>
                                        <?php else: ?>
                                            <button class="btn btn-outline-success" onclick="markAsRead(<?php echo $message['id']; ?>)">
                                                <i class="fas fa-envelope-open"></i>
                                            </button>
                                        <?php endif; ?>
                                        <button class="btn btn-outline-danger" onclick="deleteMessage(<?php echo $message['id']; ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Henüz mesaj bulunmuyor</h5>
                <p class="text-muted">Müşterilerinizden gelen mesajlar burada görünecek.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Message Detail Modal -->
<div class="modal fade" id="messageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Mesaj Detayı</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Ad Soyad:</strong>
                        <p id="messageName"></p>
                    </div>
                    <div class="col-md-6">
                        <strong>Email:</strong>
                        <p id="messageEmail"></p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Telefon:</strong>
                        <p id="messagePhone"></p>
                    </div>
                    <div class="col-md-6">
                        <strong>Tarih:</strong>
                        <p id="messageDate"></p>
                    </div>
                </div>
                <div class="mb-3">
                    <strong>Konu:</strong>
                    <p id="messageSubject"></p>
                </div>
                <div class="mb-3">
                    <strong>Mesaj:</strong>
                    <div class="border p-3 rounded" id="messageContent"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <a id="replyEmail" href="#" class="btn btn-primary">
                    <i class="fas fa-reply me-2"></i>Yanıtla
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function viewMessage(message) {
    document.getElementById('messageName').textContent = message.name;
    document.getElementById('messageEmail').textContent = message.email;
    document.getElementById('messagePhone').textContent = message.phone || '-';
    document.getElementById('messageDate').textContent = new Date(message.created_at).toLocaleString('tr-TR');
    document.getElementById('messageSubject').textContent = message.subject || 'Konu yok';
    document.getElementById('messageContent').textContent = message.message;
    document.getElementById('replyEmail').href = 'mailto:' + message.email + '?subject=Re: ' + (message.subject || 'İletişim');
    
    const modal = new bootstrap.Modal(document.getElementById('messageModal'));
    modal.show();
}

function markAsRead(id) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.innerHTML = `
        <input type="hidden" name="action" value="mark_read">
        <input type="hidden" name="id" value="${id}">
    `;
    document.body.appendChild(form);
    form.submit();
}

function markAsUnread(id) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.innerHTML = `
        <input type="hidden" name="action" value="mark_unread">
        <input type="hidden" name="id" value="${id}">
    `;
    document.body.appendChild(form);
    form.submit();
}

function deleteMessage(id) {
    if (confirm('Bu mesajı silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

function toggleSelectAll() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.message-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAll.checked;
    });
}

function markAllAsRead() {
    const checkedBoxes = document.querySelectorAll('.message-checkbox:checked');
    if (checkedBoxes.length === 0) {
        alert('Lütfen en az bir mesaj seçin.');
        return;
    }
    
    if (confirm('Seçili mesajları okundu olarak işaretlemek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = '<input type="hidden" name="action" value="mark_read_multiple">';
        
        checkedBoxes.forEach(checkbox => {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'ids[]';
            input.value = checkbox.value;
            form.appendChild(input);
        });
        
        document.body.appendChild(form);
        form.submit();
    }
}

function deleteAllRead() {
    if (confirm('Tüm okunmuş mesajları silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = '<input type="hidden" name="action" value="delete_read">';
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
