<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Girişi - <?php echo $settings['site_title'] ?? 'Wedding Master'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            overflow-x: hidden;
        }
        
        .vh-100 {
            min-height: 100vh;
        }
        .card {
            border-radius: 20px;
            border: none;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 12px;
            padding: 12px 24px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 12px 16px;
            font-size: 16px;
            transition: all 0.3s ease;
            background-color: #fff;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.15);
            background-color: #fff;
        }
        .input-group {
            position: relative;
        }
        .input-group .form-control {
            padding-left: 50px;
        }
        .input-group .input-group-text {
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            background: transparent;
            border: none;
            z-index: 3;
            padding: 0 16px;
            color: #6c757d;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 8px;
        }
        .alert {
            border-radius: 12px;
            border: none;
            padding: 16px 20px;
        }
        .alert-danger {
            background-color: #fee;
            color: #dc3545;
        }
        .alert-success {
            background-color: #efe;
            color: #198754;
        }
        .text-muted {
            color: #6c757d !important;
        }
        .fw-bold {
            font-weight: 700 !important;
        }
        .lead {
            font-size: 1.1rem;
            font-weight: 400;
        }
        .text-decoration-none:hover {
            text-decoration: underline !important;
        }
        
        /* Animations */
        @keyframes heartbeat {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .card {
            animation: fadeInUp 0.6s ease-out;
        }
        
        /* Responsive improvements */
        @media (max-width: 1200px) {
            .container-fluid {
                padding: 15px;
            }
            .card-body {
                padding: 2.5rem !important;
            }
        }
        
        @media (max-width: 992px) {
            .container-fluid {
                padding: 10px;
            }
            .card-body {
                padding: 2rem !important;
            }
            .display-4 {
                font-size: 2.5rem !important;
            }
            .fa-5x {
                font-size: 3rem !important;
            }
        }
        
        @media (max-width: 768px) {
            .container-fluid {
                padding: 0;
            }
            .row {
                margin: 0;
            }
            .col-lg-6 {
                padding: 0;
            }
            .card {
                margin: 20px;
                border-radius: 15px;
            }
            .card-body {
                padding: 1.5rem !important;
            }
            .display-4 {
                font-size: 2rem !important;
            }
            .fa-5x {
                font-size: 2.5rem !important;
            }
            .lead {
                font-size: 1rem !important;
            }
            .h5 {
                font-size: 0.9rem !important;
            }
        }
        
        @media (max-width: 576px) {
            .card {
                margin: 15px;
                border-radius: 12px;
            }
            .card-body {
                padding: 1.25rem !important;
            }
            .btn-lg {
                padding: 10px 20px;
                font-size: 16px;
            }
            .form-control {
                padding: 10px 14px;
                font-size: 16px;
            }
            .input-group .form-control {
                padding-left: 45px;
            }
            .input-group .input-group-text {
                padding: 0 12px;
            }
        }
        
        @media (max-width: 480px) {
            .card {
                margin: 10px;
            }
            .card-body {
                padding: 1rem !important;
            }
            .mb-4 {
                margin-bottom: 1rem !important;
            }
            .mb-3 {
                margin-bottom: 0.75rem !important;
            }
        }
        
        /* Mobile landscape */
        @media (max-width: 768px) and (orientation: landscape) {
            .vh-100 {
                min-height: auto;
            }
            .card-body {
                padding: 1rem !important;
            }
            .mb-4 {
                margin-bottom: 0.75rem !important;
            }
        }
        
        /* Very small screens */
        @media (max-width: 360px) {
            .card {
                margin: 5px;
                border-radius: 10px;
            }
            .card-body {
                padding: 0.75rem !important;
            }
            .btn-lg {
                padding: 8px 16px;
                font-size: 14px;
            }
            .form-control {
                padding: 8px 12px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <?php echo $content ?? ''; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Form enhancement
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form');
            const inputs = document.querySelectorAll('.form-control');
            const submitBtn = document.querySelector('.btn-primary');
            
            // Add focus effects
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.classList.add('focused');
                });
                
                input.addEventListener('blur', function() {
                    if (!this.value) {
                        this.parentElement.classList.remove('focused');
                    }
                });
                
                // Check if input has value on load
                if (input.value) {
                    input.parentElement.classList.add('focused');
                }
            });
            
            // Form submission enhancement
            form.addEventListener('submit', function(e) {
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Giriş yapılıyor...';
                submitBtn.disabled = true;
            });
            
            // Auto-hide alerts
            setTimeout(function() {
                const alerts = document.querySelectorAll('.alert');
                alerts.forEach(function(alert) {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                });
            }, 5000);
        });
    </script>
</body>
</html>
