<?php
// views/admin/login.php
// Admin login page

$page_title = 'Admin Girişi';
ob_start();
?>

<div class="container-fluid vh-100">
    <div class="row h-100">
        <!-- Sol Panel - Desktop'ta görünür -->
        <div class="col-lg-6 d-none d-lg-flex">
            <div class="h-100 w-100 d-flex align-items-center justify-content-center" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); position: relative; overflow: hidden;">
                <!-- Background Pattern -->
                <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; opacity: 0.1;">
                    <div style="position: absolute; top: 20%; left: 10%; width: 100px; height: 100px; border: 2px solid white; border-radius: 50%;"></div>
                    <div style="position: absolute; top: 60%; right: 15%; width: 60px; height: 60px; border: 2px solid white; border-radius: 50%;"></div>
                    <div style="position: absolute; bottom: 20%; left: 20%; width: 80px; height: 80px; border: 2px solid white; border-radius: 50%;"></div>
                </div>
                
                <div class="text-center text-white px-4" style="position: relative; z-index: 2;">
                    <div class="mb-4">
                        <i class="fas fa-heart fa-5x mb-3" style="animation: heartbeat 2s ease-in-out infinite;"></i>
                    </div>
                    <h1 class="display-4 fw-bold mb-3">Wedding Master</h1>
                    <p class="lead mb-2">Profesyonel Düğün Organizasyon</p>
                    <p class="h5 mb-0">Admin Paneline Hoş Geldiniz</p>
                </div>
            </div>
        </div>
        
        <!-- Sağ Panel - Login Form -->
        <div class="col-lg-6 col-12 d-flex align-items-center justify-content-center">
            <div class="w-100 px-3" style="max-width: 400px;">
                <div class="card shadow-lg border-0">
                    <div class="card-body p-4 p-lg-5">
                        <div class="text-center mb-4">
                            <div class="mb-3">
                                <i class="fas fa-heart fa-3x text-primary"></i>
                            </div>
                            <h3 class="fw-bold text-dark">Admin Girişi</h3>
                            <p class="text-muted mb-0">Hesabınıza giriş yapın</p>
                        </div>

                        <!-- Flash Messages -->
                        <?php if ($flash_success = getFlashMessage('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i><?php echo $flash_success; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <?php if ($flash_error = getFlashMessage('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></i><?php echo $flash_error; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="/admin/login">
                            <div class="mb-4">
                                <label for="username" class="form-label">Kullanıcı Adı</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-user"></i>
                                    </span>
                                    <input type="text" class="form-control" id="username" name="username" placeholder="Kullanıcı adınızı girin" required>
                                </div>
                            </div>

                            <div class="mb-4">
                                <label for="password" class="form-label">Şifre</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-lock"></i>
                                    </span>
                                    <input type="password" class="form-control" id="password" name="password" placeholder="Şifrenizi girin" required>
                                </div>
                            </div>

                            <div class="d-grid mb-3">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-sign-in-alt me-2"></i>Giriş Yap
                                </button>
                            </div>
                        </form>

                        <div class="text-center mt-4">
                            <a href="/" class="text-decoration-none">
                                <i class="fas fa-arrow-left me-1"></i>Siteye Dön
                            </a>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <div class="card border-0 bg-light">
                        <div class="card-body p-3">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                <strong>Varsayılan giriş bilgileri:</strong><br>
                                <span class="text-primary">Kullanıcı Adı:</span> admin<br>
                                <span class="text-primary">Şifre:</span> admin123
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include 'views/admin/login_layout.php';
?>