<?php
// views/admin/gallery/index.php
// Gallery management page

$page_title = 'Galeri Yönetimi';
ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-images me-2"></i>Galeri</h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#uploadModal">
        <i class="fas fa-upload me-2"></i>Resim Yükle
    </button>
</div>

<!-- Gallery Categories -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">Kategoriler</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <?php foreach ($categories as $category): ?>
                <div class="col-md-3 mb-3">
                    <div class="card border">
                        <div class="card-body text-center">
                            <h6><?php echo htmlspecialchars($category['name']); ?></h6>
                            <span class="badge bg-primary"><?php echo $category['image_count']; ?> resim</span>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Gallery Images -->
<div class="card">
    <div class="card-body">
        <?php if (!empty($images)): ?>
            <div class="row">
                <?php foreach ($images as $image): ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                        <div class="card">
                            <div class="position-relative">
                                <img src="/<?php echo htmlspecialchars($image['thumbnail_path'] ?: $image['image_path']); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo htmlspecialchars($image['alt_text'] ?: $image['title']); ?>"
                                     style="height: 200px; object-fit: cover;">
                                <div class="position-absolute top-0 end-0 p-2">
                                    <?php if ($image['is_featured']): ?>
                                        <span class="badge bg-warning">Öne Çıkan</span>
                                    <?php endif; ?>
                                    <?php if (!$image['is_active']): ?>
                                        <span class="badge bg-secondary">Pasif</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <h6 class="card-title"><?php echo htmlspecialchars($image['title'] ?: 'Başlıksız'); ?></h6>
                                <p class="card-text small text-muted">
                                    <?php echo htmlspecialchars($image['category_name'] ?: 'Kategori yok'); ?>
                                </p>
                                <div class="btn-group btn-group-sm w-100">
                                    <button class="btn btn-outline-primary" onclick="editImage(<?php echo htmlspecialchars(json_encode($image)); ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-outline-info" onclick="viewImage('<?php echo htmlspecialchars($image['image_path']); ?>')">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <button class="btn btn-outline-danger" onclick="deleteImage(<?php echo $image['id']; ?>)">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-images fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Henüz resim yüklenmemiş</h5>
                <p class="text-muted">İlk resminizi yüklemek için yukarıdaki butona tıklayın.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Upload Modal -->
<div class="modal fade" id="uploadModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Resim Yükle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="uploadForm" method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" name="action" value="upload">
                    
                    <div class="mb-3">
                        <label for="image" class="form-label">Resim Dosyası *</label>
                        <input type="file" class="form-control" id="image" name="image" accept="image/*" required>
                        <div class="form-text">Maksimum dosya boyutu: 5MB. Desteklenen formatlar: JPG, PNG, GIF, WebP</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="category_id" class="form-label">Kategori</label>
                                <select class="form-select" id="category_id" name="category_id">
                                    <option value="">Kategori Seçin</option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>">
                                            <?php echo htmlspecialchars($category['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sıra</label>
                                <input type="number" class="form-control" id="sort_order" name="sort_order" value="0">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="title" class="form-label">Başlık</label>
                        <input type="text" class="form-control" id="title" name="title">
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Açıklama</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="alt_text" class="form-label">Alt Metin</label>
                        <input type="text" class="form-control" id="alt_text" name="alt_text">
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured">
                        <label class="form-check-label" for="is_featured">
                            Öne Çıkan Resim
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Yükle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Image Modal -->
<div class="modal fade" id="editImageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Resim Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editImageForm" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update">
                    <input type="hidden" name="id" id="editImageId">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_category_id" class="form-label">Kategori</label>
                                <select class="form-select" id="edit_category_id" name="category_id">
                                    <option value="">Kategori Seçin</option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>">
                                            <?php echo htmlspecialchars($category['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_sort_order" class="form-label">Sıra</label>
                                <input type="number" class="form-control" id="edit_sort_order" name="sort_order">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="edit_title" class="form-label">Başlık</label>
                        <input type="text" class="form-control" id="edit_title" name="title">
                    </div>

                    <div class="mb-3">
                        <label for="edit_description" class="form-label">Açıklama</label>
                        <textarea class="form-control" id="edit_description" name="description" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="edit_alt_text" class="form-label">Alt Metin</label>
                        <input type="text" class="form-control" id="edit_alt_text" name="alt_text">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="edit_is_featured" name="is_featured">
                                <label class="form-check-label" for="edit_is_featured">
                                    Öne Çıkan Resim
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="edit_is_active" name="is_active" checked>
                                <label class="form-check-label" for="edit_is_active">
                                    Aktif
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Image Preview Modal -->
<div class="modal fade" id="imagePreviewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Resim Önizleme</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <img id="previewImage" src="" class="img-fluid" alt="Resim önizleme">
            </div>
        </div>
    </div>
</div>

<script>
function editImage(image) {
    document.getElementById('editImageId').value = image.id;
    document.getElementById('edit_category_id').value = image.category_id || '';
    document.getElementById('edit_title').value = image.title || '';
    document.getElementById('edit_description').value = image.description || '';
    document.getElementById('edit_alt_text').value = image.alt_text || '';
    document.getElementById('edit_sort_order').value = image.sort_order;
    document.getElementById('edit_is_featured').checked = image.is_featured == 1;
    document.getElementById('edit_is_active').checked = image.is_active == 1;
    
    const modal = new bootstrap.Modal(document.getElementById('editImageModal'));
    modal.show();
}

function viewImage(imagePath) {
    document.getElementById('previewImage').src = '/' + imagePath;
    const modal = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
    modal.show();
}

function deleteImage(id) {
    if (confirm('Bu resmi silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
