<?php
// views/admin/dashboard.php
// Admin dashboard view

$page_title = 'Dashboard';
ob_start();
?>

<div class="row">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Okunmamış Mesajlar</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $unread_messages ?? 0; ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-envelope fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Toplam Hizmetler</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $total_services ?? 0; ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-concierge-bell fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Galeri Resimleri</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $total_images ?? 0; ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-images fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Referanslar</div>
                        <div class="h5 mb-0 font-weight-bold"><?php echo $total_testimonials ?? 0; ?></div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-quote-left fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-chart-line me-2"></i>Son Mesajlar
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($recent_messages)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Ad Soyad</th>
                                    <th>Email</th>
                                    <th>Konu</th>
                                    <th>Tarih</th>
                                    <th>Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_messages as $message): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($message['name']); ?></td>
                                        <td><?php echo htmlspecialchars($message['email']); ?></td>
                                        <td><?php echo htmlspecialchars($message['subject'] ?: 'Konu yok'); ?></td>
                                        <td><?php echo formatDate($message['created_at'], 'd.m.Y H:i'); ?></td>
                                        <td>
                                            <?php if ($message['is_read']): ?>
                                                <span class="badge bg-success">Okundu</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning">Okunmadı</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <p class="text-muted">Henüz mesaj bulunmuyor.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-tools me-2"></i>Hızlı İşlemler
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="/admin/services" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>Yeni Hizmet Ekle
                    </a>
                    <a href="/admin/gallery" class="btn btn-outline-primary">
                        <i class="fas fa-upload me-2"></i>Resim Yükle
                    </a>
                    <a href="/admin/messages" class="btn btn-outline-primary">
                        <i class="fas fa-envelope me-2"></i>Mesajları Görüntüle
                    </a>
                    <a href="/admin/settings" class="btn btn-outline-primary">
                        <i class="fas fa-cog me-2"></i>Site Ayarları
                    </a>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>Site Bilgileri
                </h5>
            </div>
            <div class="card-body">
                <p><strong>Site Adı:</strong> <?php echo htmlspecialchars($settings['site_title'] ?? 'Wedding Master'); ?></p>
                <p><strong>İletişim Email:</strong> <?php echo htmlspecialchars($settings['contact_email'] ?? 'Belirtilmemiş'); ?></p>
                <p><strong>İletişim Telefon:</strong> <?php echo htmlspecialchars($settings['contact_phone'] ?? 'Belirtilmemiş'); ?></p>
                <p><strong>Son Güncelleme:</strong> <?php echo date('d.m.Y H:i'); ?></p>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include 'views/admin/layout.php';
?>
