<?php
// models/Testimonial.php
// Testimonial model

require_once 'BaseModel.php';

class Testimonial extends BaseModel {
    protected $table = 'testimonials';

    // Get featured testimonials
    public function getFeatured($limit = 3) {
        $sql = "SELECT * FROM {$this->table} WHERE is_featured = 1 AND is_active = 1 ORDER BY sort_order ASC LIMIT :limit";
        $stmt = $this->db->prepare($sql);
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Get all active testimonials ordered by sort_order
    public function getAllActive() {
        return $this->getActive(null, 0, 'sort_order ASC');
    }

    // Update featured status
    public function updateFeatured($id, $isFeatured) {
        return $this->update($id, [
            'is_featured' => $isFeatured,
            'updated_at' => date('Y-m-d H:i:s')
        ]);
    }
}
?>
