<?php
// models/Service.php
// Service model for managing wedding services

require_once 'BaseModel.php';

class Service extends BaseModel {
    protected $table = 'services';

    // Get featured services
    public function getFeatured($limit = 6) {
        $sql = "SELECT * FROM {$this->table} WHERE is_featured = 1 AND is_active = 1 ORDER BY sort_order ASC LIMIT :limit";
        $stmt = $this->db->prepare($sql);
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Get all active services ordered by sort_order
    public function getAllActive() {
        return $this->getActive(null, 0, 'sort_order ASC');
    }

    // Search services
    public function searchServices($searchTerm) {
        $searchColumns = ['title', 'description', 'content'];
        return $this->search($searchTerm, $searchColumns);
    }

    // Update service status
    public function updateStatus($id, $isActive) {
        return $this->update($id, [
            'is_active' => $isActive,
            'updated_at' => date('Y-m-d H:i:s')
        ]);
    }

    // Update featured status
    public function updateFeatured($id, $isFeatured) {
        return $this->update($id, [
            'is_featured' => $isFeatured,
            'updated_at' => date('Y-m-d H:i:s')
        ]);
    }
}
?>
