<?php
// models/Page.php
// Page model for managing dynamic pages

require_once 'BaseModel.php';

class Page extends BaseModel {
    protected $table = 'pages';

    // Get page by slug
    public function getBySlug($slug) {
        $sql = "SELECT * FROM {$this->table} WHERE slug = :slug AND is_active = 1";
        $stmt = $this->db->prepare($sql);
        $stmt->bindParam(':slug', $slug);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    // Get all active pages ordered by sort_order
    public function getAllActive() {
        return $this->getActive(null, 0, 'sort_order ASC');
    }

    // Update page content
    public function updateContent($id, $content) {
        return $this->update($id, [
            'content' => $content,
            'updated_at' => date('Y-m-d H:i:s')
        ]);
    }

    // Check if slug exists (excluding current record)
    public function slugExists($slug, $excludeId = null) {
        $sql = "SELECT COUNT(*) as count FROM {$this->table} WHERE slug = :slug";
        if ($excludeId) {
            $sql .= " AND {$this->primaryKey} != :exclude_id";
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindParam(':slug', $slug);
        if ($excludeId) {
            $stmt->bindParam(':exclude_id', $excludeId);
        }
        $stmt->execute();
        
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['count'] > 0;
    }
}
?>
