<?php
// models/GalleryCategory.php
// Gallery category model

require_once 'BaseModel.php';

class GalleryCategory extends BaseModel {
    protected $table = 'gallery_categories';

    // Get all active categories ordered by sort_order
    public function getAllActive() {
        return $this->getActive(null, 0, 'sort_order ASC');
    }

    // Get category with image count
    public function getWithImageCount() {
        $sql = "SELECT gc.*, COUNT(gi.id) as image_count 
                FROM {$this->table} gc 
                LEFT JOIN gallery_images gi ON gc.id = gi.category_id AND gi.is_active = 1 
                WHERE gc.is_active = 1 
                GROUP BY gc.id 
                ORDER BY gc.sort_order ASC";
        $stmt = $this->db->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
