<?php
// models/ContactMessage.php
// Contact message model

require_once 'BaseModel.php';

class ContactMessage extends BaseModel {
    protected $table = 'contact_messages';

    // Get unread messages
    public function getUnread() {
        $sql = "SELECT * FROM {$this->table} WHERE is_read = 0 ORDER BY created_at DESC";
        $stmt = $this->db->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Get recent messages
    public function getRecent($limit = 10) {
        $sql = "SELECT * FROM {$this->table} ORDER BY created_at DESC LIMIT :limit";
        $stmt = $this->db->prepare($sql);
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Mark message as read
    public function markAsRead($id) {
        return $this->update($id, ['is_read' => 1]);
    }

    // Mark message as unread
    public function markAsUnread($id) {
        return $this->update($id, ['is_read' => 0]);
    }

    // Count unread messages
    public function countUnread() {
        return $this->count('is_read = 0');
    }
}
?>
