<?php
// index.php
// Main entry point for the wedding organization website

require_once 'config/config.php';
require_once 'includes/functions.php';
require_once 'controllers/BaseController.php';
require_once 'controllers/HomeController.php';

// Simple routing
$request = $_SERVER['REQUEST_URI'];
$path = parse_url($request, PHP_URL_PATH);

// Remove trailing slash
$path = rtrim($path, '/');

// Route handling
try {
    $controller = new HomeController();
    
    switch ($path) {
        case '':
        case '/':
            $controller->index();
            break;
            
        case '/about':
        case '/hakkimizda':
            $controller->about();
            break;
            
        case '/services':
        case '/hizmetler':
            $controller->services();
            break;
            
        case '/gallery':
        case '/galeri':
            $controller->gallery();
            break;
            
        case '/contact':
        case '/iletisim':
            $controller->contact();
            break;
            
        case '/admin':
            header('Location: /admin/dashboard');
            exit;
            
        case '/admin/dashboard':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->dashboard();
            break;
            
        case '/admin/login':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->login();
            break;
            
        case '/admin/logout':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->logout();
            break;
            
        case '/admin/services':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->services();
            break;
            
        case '/admin/gallery':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->gallery();
            break;
            
        case '/admin/messages':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->messages();
            break;
            
        case '/admin/testimonials':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->testimonials();
            break;
            
        case '/admin/pages':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->pages();
            break;
            
        case '/admin/settings':
            require_once 'controllers/AdminController.php';
            $adminController = new AdminController();
            $adminController->settings();
            break;
            
        default:
            // Check if it's a dynamic page
            if (strpos($path, '/page/') === 0) {
                $slug = substr($path, 6); // Remove '/page/' prefix
                $controller->page($slug);
            } else {
                // 404 error
                http_response_code(404);
                echo '<!DOCTYPE html>
                <html lang="tr">
                <head>
                    <meta charset="UTF-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>404 - Sayfa Bulunamadı</title>
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
                </head>
                <body class="bg-light">
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-md-6 text-center">
                                <div class="mt-5">
                                    <h1 class="display-1 text-primary">404</h1>
                                    <h2 class="mb-4">Sayfa Bulunamadı</h2>
                                    <p class="lead mb-4">Aradığınız sayfa mevcut değil veya taşınmış olabilir.</p>
                                    <a href="/" class="btn btn-primary">Ana Sayfaya Dön</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </body>
                </html>';
            }
            break;
    }
    
} catch (Exception $e) {
    // Error handling
    error_log('Error: ' . $e->getMessage());
    
    if (defined('DEBUG') && DEBUG) {
        echo '<div class="alert alert-danger">Error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    } else {
        http_response_code(500);
        echo '<!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>500 - Sunucu Hatası</title>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
        </head>
        <body class="bg-light">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-6 text-center">
                        <div class="mt-5">
                            <h1 class="display-1 text-danger">500</h1>
                            <h2 class="mb-4">Sunucu Hatası</h2>
                            <p class="lead mb-4">Bir hata oluştu. Lütfen daha sonra tekrar deneyin.</p>
                            <a href="/" class="btn btn-primary">Ana Sayfaya Dön</a>
                        </div>
                    </div>
                </div>
            </div>
        </body>
        </html>';
    }
}
?>
