# cPanel Kurulum Talimatları - Wedding Master

## 🚀 cPanel'e Yükleme Adımları

### 1. Dosyaları Yükleme
1. Tüm proje dosyalarını cPanel File Manager ile `public_html` klasörüne yükleyin
2. Dosya izinlerini ayarlayın:
   - `uploads/` klasörü: 755
   - `uploads/gallery/` klasörü: 755
   - `uploads/services/` klasörü: 755
   - `uploads/testimonials/` klasörü: 755
   - `uploads/pages/` klasörü: 755

### 2. Veritabanı Oluşturma
1. cPanel → MySQL Databases
2. Yeni veritabanı oluşturun (örn: `wedding_org`)
3. Yeni kullanıcı oluşturun (örn: `wedding_user`)
4. Kullanıcıyı veritabanına ekleyin ve tüm yetkileri verin
5. `database.sql` dosyasını phpMyAdmin ile çalıştırın

### 3. Konfigürasyon Ayarları

#### config/database.php dosyasını düzenleyin:
```php
private $host = 'localhost';
private $db_name = 'saboproj_wedding';  // ✅ Güncellendi
private $username = 'saboproj_wedding';  // ✅ Güncellendi
private $password = 'e!##RFxNs@ldgFa[';  // ✅ Güncellendi
```

#### config/config.php dosyasını düzenleyin:
```php
define('SITE_URL', 'https://yourdomain.com');  // Domain adresinizi buraya yazın
define('DB_NAME', 'saboproj_wedding');  // ✅ Güncellendi
define('DB_USER', 'saboproj_wedding');  // ✅ Güncellendi
define('DB_PASS', 'e!##RFxNs@ldgFa[');  // ✅ Güncellendi
define('SMTP_HOST', 'mail.yourdomain.com');
define('SMTP_USERNAME', 'noreply@yourdomain.com');
define('SMTP_PASSWORD', 'your_email_password');
define('SECRET_KEY', 'wedding-master-2024-secure-key-' . md5('saboproj_wedding'));  // ✅ Güncellendi
```

### 4. .htaccess Kontrolü
- `.htaccess` dosyasının yüklendiğinden emin olun
- mod_rewrite modülünün aktif olduğunu kontrol edin

### 5. Test Etme
1. `https://yourdomain.com` adresine gidin
2. Site açılıyorsa kurulum başarılı
3. `https://yourdomain.com/admin` adresine gidin
4. Admin girişi yapın:
   - Kullanıcı: `admin`
   - Şifre: `admin123`

### 6. İlk Ayarlar
1. Admin panelinde Settings → Site Ayarları
2. Site başlığı, açıklama, iletişim bilgilerini güncelleyin
3. Sosyal medya linklerini ekleyin
4. İlk hizmetlerinizi ekleyin
5. Galeri fotoğraflarını yükleyin

## ⚠️ Önemli Notlar

### Güvenlik
- İlk girişten sonra admin şifresini değiştirin
- `SECRET_KEY` değerini güvenli bir anahtar ile değiştirin
- Production'da `DEBUG` değerini `false` yapın

### Dosya İzinleri
```bash
uploads/ → 755
uploads/gallery/ → 755
uploads/services/ → 755
uploads/testimonials/ → 755
uploads/pages/ → 755
```

### Email Ayarları
- cPanel Email Accounts'tan email hesabı oluşturun
- SMTP ayarlarını doğru şekilde yapılandırın
- Test email gönderimi yapın

## 🔧 Sorun Giderme

### Veritabanı Bağlantı Hatası
- Veritabanı adı ve kullanıcı adının doğru olduğunu kontrol edin
- cPanel kullanıcı adı önekini unutmayın
- Şifrenin doğru olduğunu kontrol edin

### 404 Hatası
- `.htaccess` dosyasının yüklendiğini kontrol edin
- mod_rewrite modülünün aktif olduğunu kontrol edin
- Dosya yollarının doğru olduğunu kontrol edin

### Resim Yükleme Hatası
- `uploads/` klasör izinlerini kontrol edin
- PHP upload limitlerini kontrol edin
- Dosya boyutu limitlerini kontrol edin

### Email Gönderim Hatası
- SMTP ayarlarını kontrol edin
- Email hesabı şifresini kontrol edin
- Port ayarlarını kontrol edin (587 veya 465)

## 📞 Destek

Herhangi bir sorun yaşarsanız:
1. cPanel Error Logs'u kontrol edin
2. PHP Error Logs'u kontrol edin
3. Veritabanı bağlantısını test edin
4. Dosya izinlerini kontrol edin

## 🎉 Başarılı Kurulum Sonrası

Kurulum tamamlandıktan sonra:
1. ✅ Site açılıyor
2. ✅ Admin paneli çalışıyor
3. ✅ Veritabanı bağlantısı aktif
4. ✅ Resim yükleme çalışıyor
5. ✅ Email gönderimi çalışıyor
6. ✅ Tüm sayfalar dinamik

Artık sitenizi admin panelinden tamamen yönetebilirsiniz!
